/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.FloorTrapBlockEntity;
import net.geforcemods.securitycraft.blocks.SometimesVisibleBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloorTrapBlock
extends SometimesVisibleBlock {
    public FloorTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        FloorTrapBlockEntity trap1;
        BlockEntity blockEntity;
        if (pos.getY() == neighborPos.getY() && (blockEntity = level.getBlockEntity(pos)) instanceof FloorTrapBlockEntity && (trap1 = (FloorTrapBlockEntity)blockEntity).isModuleEnabled(ModuleType.SMART) && (blockEntity = level.getBlockEntity(neighborPos)) instanceof FloorTrapBlockEntity) {
            FloorTrapBlockEntity trap2 = (FloorTrapBlockEntity)blockEntity;
            if (trap1.getOwner().owns(trap2) && ((Boolean)level.getBlockState(neighborPos).getValue((Property)INVISIBLE)).booleanValue()) {
                if (trap1.shouldDisappearInstantlyInChains()) {
                    trap1.scheduleDisappear(0, true);
                } else {
                    trap1.scheduleDisappear(true);
                }
            }
        }
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return adjacentState.is((Block)this) && (Boolean)adjacentState.getValue((Property)INVISIBLE) == false || super.skipRendering(state, adjacentState, side);
    }

    @Override
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape getCollisionShapeWhenInvisible() {
        return Shapes.empty();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)INVISIBLE) != false ? FloorTrapBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get()), FloorTrapBlockEntity::particleTick) : null;
        }
        return FloorTrapBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FloorTrapBlockEntity(pos, state);
    }
}

