/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class KeycardReaderMenu
extends AbstractContainerMenu {
    private final SimpleContainer itemInventory = new SimpleContainer(1);
    public final Slot keycardSlot;
    public final KeycardReaderBlockEntity be;
    private ContainerLevelAccess worldPosCallable;

    public KeycardReaderMenu(int windowId, Inventory inventory, Level level, BlockPos pos) {
        super((MenuType)SCContent.KEYCARD_READER_MENU.get(), windowId);
        int i;
        this.be = (KeycardReaderBlockEntity)level.getBlockEntity(pos);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, 9 + j + i * 9, 8 + j * 18, 167 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 225));
        }
        this.keycardSlot = this.addSlot(new Slot((Container)this.itemInventory, 0, 35, 86){

            public boolean mayPlace(ItemStack stack) {
                if (!(stack.getItem() instanceof KeycardItem) || stack.getItem() == SCContent.LIMITED_USE_KEYCARD.get()) {
                    return false;
                }
                if (!stack.has(SCContent.KEYCARD_DATA) || !stack.has(SCContent.OWNER_DATA)) {
                    return true;
                }
                Owner keycardOwner = ((OwnerData)stack.getOrDefault(SCContent.OWNER_DATA, (Object)OwnerData.DEFAULT)).toOwner();
                String keycardOwnerUUID = keycardOwner.getUUID();
                return keycardOwnerUUID.isEmpty() || TeamUtils.areOnSameTeam(KeycardReaderMenu.this.be.getOwner(), keycardOwner) || keycardOwnerUUID.equals(KeycardReaderMenu.this.be.getOwner().getUUID());
            }
        });
    }

    public void link(Optional<String> usableBy) {
        ItemStack keycard = this.keycardSlot.getItem();
        if (!keycard.isEmpty()) {
            keycard.update(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT, oldData -> oldData.setSignatureAndUsableBy(this.be.getSignature(), usableBy));
            keycard.set(SCContent.OWNER_DATA, (Object)OwnerData.fromOwner(this.be.getOwner(), false));
        }
    }

    public void setKeycardUsesLeft(int usesLeft) {
        KeycardData keycardData;
        ItemStack keycard = this.keycardSlot.getItem();
        if (!keycard.isEmpty() && (keycardData = (KeycardData)keycard.getOrDefault(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT)).limited()) {
            keycard.set(SCContent.KEYCARD_DATA, (Object)keycardData.setUsesLeft(usesLeft));
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.itemInventory);
        this.be.setChanged();
    }

    public ItemStack quickMoveStack(Player player, int id) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(id);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (id >= 36) {
                if (!this.moveItemStackTo(slotStack, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return slotStackCopy;
    }

    public boolean stillValid(Player player) {
        return KeycardReaderMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)((Block)SCContent.KEYCARD_READER.get()));
    }
}

