/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items.properties;

import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.GlobalPositionComponent;
import net.geforcemods.securitycraft.items.properties.HitCheck;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public record BlockLinked(DataComponentType<?> positionComponent, HitCheck hitCheck) {
    public static final float NO_POSITIONS = 0.0f;
    public static final float UNKNOWN = 0.25f;
    public static final float NOT_LINKED = 0.5f;
    public static final float LINKED = 0.75f;

    public float get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
        Object object = stack.get(this.positionComponent);
        if (object instanceof GlobalPositionComponent) {
            Player player;
            BlockHitResult hitResult;
            GlobalPositionComponent positions = (GlobalPositionComponent)object;
            if (level != null && entity instanceof Player && (hitResult = HitCheck.getHitResult((Level)level, player = (Player)entity)) != null) {
                IOwnable ownable;
                BlockPos pos = hitResult.getBlockPos();
                BlockEntity be = level.getBlockEntity(pos);
                if (!(be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || be != null && !(be.getBlockState().getBlock() instanceof IBlockMine) && !IDisguisable.getDisguisedBlockState(be).isPresent())) {
                    return this.returnBasedOnComponent(positions);
                }
                if (this.hitCheck.isValidHitResult((Level)level, hitResult)) {
                    GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
                    return positions.isPositionAdded(globalPos) ? 0.75f : 0.5f;
                }
            }
            return this.returnBasedOnComponent(positions);
        }
        return 0.0f;
    }

    private final float returnBasedOnComponent(GlobalPositionComponent positions) {
        return positions.isEmpty() ? 0.0f : 0.25f;
    }
}

