/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.geforcemods.securitycraft.ConfigHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class PasscodeUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static HashingThread hashingThread;
    private static final Map<Player, Long> LAST_PASSCODE_CHECKS;

    private PasscodeUtils() {
    }

    public static void startHashingThread(Executor executor) {
        if (hashingThread == null) {
            hashingThread = new HashingThread(executor);
            hashingThread.start();
        }
    }

    public static void stopHashingThread() {
        if (hashingThread != null) {
            hashingThread.interrupt();
            hashingThread = null;
        }
    }

    public static CompoundTag filterPasscodeAndSaltFromTag(CompoundTag tag) {
        tag.remove("passcode");
        tag.remove("saltKey");
        return tag;
    }

    public static String hashPasscodeWithoutSalt(String original) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            return PasscodeUtils.bytesToString(md.digest(original.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void hashPasscode(String passcode, byte[] salt, Consumer<byte[]> afterHashing) {
        if (passcode != null && salt != null) {
            PasscodeUtils.hashingThread.workList.addLast(new HashingWork(passcode, salt, afterHashing));
        }
    }

    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte currentByte : bytes) {
            sb.append(Integer.toString((currentByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static byte[] stringToBytes(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            int index = i * 2;
            int parsedInt = Integer.parseInt(string.substring(index, index + 2), 16);
            bytes[i] = (byte)parsedInt;
        }
        return bytes;
    }

    public static byte[] generateSalt() {
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    public static void setOnCooldown(Player player) {
        LAST_PASSCODE_CHECKS.put(player, System.currentTimeMillis());
    }

    public static boolean isOnCooldown(Player player) {
        if (!LAST_PASSCODE_CHECKS.containsKey(player) || System.currentTimeMillis() > LAST_PASSCODE_CHECKS.get(player) + (long)((Integer)ConfigHandler.SERVER.passcodeCheckCooldown.get()).intValue()) {
            LAST_PASSCODE_CHECKS.remove(player);
            return false;
        }
        return true;
    }

    static {
        LAST_PASSCODE_CHECKS = new HashMap<Player, Long>();
    }

    private static class HashingThread
    extends Thread {
        private double sleepOverhead = 0.0;
        private final ConcurrentLinkedDeque<HashingWork> workList = new ConcurrentLinkedDeque();
        private final Executor mainExecutor;

        private HashingThread(Executor mainExecutor) {
            this.mainExecutor = mainExecutor;
            this.setDaemon(true);
            this.setName("SecurityCraft Passcode Hashing");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long start = System.nanoTime();
                    if (!this.workList.isEmpty()) {
                        HashingWork work = this.workList.pop();
                        byte[] hash = HashingThread.hashPasscode(work.passcode, work.salt);
                        this.mainExecutor.execute(() -> work.afterHashing.accept(hash));
                    }
                    double d = (double)(System.nanoTime() - start) / 1000000.0 + this.sleepOverhead;
                    long sleepTime = 10L - (long)d;
                    this.sleepOverhead = d % 1.0;
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private static byte[] hashPasscode(String passcode, byte[] salt) {
            try {
                PBEKeySpec spec = new PBEKeySpec(passcode.toCharArray(), salt, 65536, 128);
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                return factory.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private record HashingWork(String passcode, byte[] salt, Consumer<byte[]> afterHashing) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HashingWork hashingWork = (HashingWork)obj;
            return this.passcode != null && this.passcode.equals(hashingWork.passcode) && Arrays.equals(this.salt, hashingWork.salt);
        }

        @Override
        public int hashCode() {
            return 31 * this.passcode.hashCode() + Arrays.hashCode(this.salt);
        }

        @Override
        public String toString() {
            return "HashingWork{passcode=" + this.passcode + ", salt=" + Arrays.toString(this.salt) + "}";
        }
    }
}

