/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task;

import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidExtension;
import com.github.tartaricacid.touhoulittlemaid.api.entity.ai.IExtraMaidBrain;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ExtraMaidBrainManager;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.item.control.BroomControlManager;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import java.util.List;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.compat.PlayerRevive;
import studio.fantasyit.maid_useful_task.data.MaidConfigKeys;
import studio.fantasyit.maid_useful_task.data.MaidLoggingConfig;
import studio.fantasyit.maid_useful_task.data.MaidReviveConfig;
import studio.fantasyit.maid_useful_task.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_useful_task.task.MaidLocateTask;
import studio.fantasyit.maid_useful_task.task.MaidRevivePlayerTask;
import studio.fantasyit.maid_useful_task.task.MaidTreeTask;
import studio.fantasyit.maid_useful_task.vehicle.broom.BroomController;

@LittleMaidExtension
public class UsefulTaskExtension
implements ILittleMaid {
    public void addMaidTask(TaskManager manager) {
        super.addMaidTask(manager);
        if (Config.enableLoggingTask) {
            manager.add((IMaidTask)new MaidTreeTask());
        }
        if (Config.enableLocateTask) {
            manager.add((IMaidTask)new MaidLocateTask());
        }
        if (Config.enableReviveTask && PlayerRevive.isEnable()) {
            manager.add((IMaidTask)new MaidRevivePlayerTask());
        }
    }

    public void addExtraMaidBrain(ExtraMaidBrainManager manager) {
        manager.addExtraMaidBrain(new IExtraMaidBrain(this){

            public List<MemoryModuleType<?>> getExtraMemoryTypes() {
                return List.of((MemoryModuleType)MemoryModuleRegistry.DESTROY_TARGET.get(), (MemoryModuleType)MemoryModuleRegistry.PLACE_TARGET.get(), (MemoryModuleType)MemoryModuleRegistry.BLOCK_UP_TARGET.get(), (MemoryModuleType)MemoryModuleRegistry.BLOCK_VALIDATION.get(), (MemoryModuleType)MemoryModuleRegistry.CURRENT_WORK.get(), (MemoryModuleType)MemoryModuleRegistry.COMMON_BLOCK_CACHE.get(), (MemoryModuleType)MemoryModuleRegistry.IS_ALLOW_HANDLE_VEHICLE.get(), (MemoryModuleType)MemoryModuleRegistry.LOCATE_ITEM.get());
            }
        });
    }

    public void registerTaskData(TaskDataRegister register) {
        MaidLoggingConfig.KEY = register.register((TaskDataKey)new MaidLoggingConfig());
        MaidConfigKeys.addKey(MaidLoggingConfig.LOCATION, MaidLoggingConfig.KEY, MaidLoggingConfig.Data::getDefault);
        MaidReviveConfig.KEY = register.register((TaskDataKey)new MaidReviveConfig());
        MaidConfigKeys.addKey(MaidReviveConfig.LOCATION, MaidReviveConfig.KEY, MaidReviveConfig.Data::getDefault);
    }

    public void registerBroomControl(BroomControlManager register) {
        register.register(BroomController::new);
    }
}

