/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.data.MaidReviveConfig;
import studio.fantasyit.maid_useful_task.util.InvUtil;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.server.PlayerReviveServer;

public class PlayerReviveBehavior
extends Behavior<EntityMaid> {
    ServerPlayer targetPlayer;
    IBleeding bleeding;
    boolean startedRevive;
    Set<UUID> aggroEntities;

    public PlayerReviveBehavior() {
        super(Map.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryStatus.VALUE_PRESENT), 600);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        Optional memory = maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return memory.map(list -> list.find(entity -> entity instanceof Player).map(ep -> PlayerReviveServer.getBleeding((Player)((ServerPlayer)ep))).anyMatch(IBleeding::isBleeding)).orElse(false);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        super.start(level, (LivingEntity)maid, p_22542_);
        this.aggroEntities = new HashSet<UUID>();
        this.startedRevive = false;
        boolean ownerOnly = ((MaidReviveConfig.Data)maid.getOrCreateData(MaidReviveConfig.KEY, (Object)MaidReviveConfig.Data.getDefault())).ownerOnly();
        LivingEntity owner = maid.getOwner();
        Optional memory = maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        this.targetPlayer = memory.flatMap(list -> list.find(entity -> entity instanceof Player).map(ep -> (ServerPlayer)ep).filter(sp -> owner != null && sp.is((Entity)owner) || !ownerOnly).filter(ep -> PlayerReviveServer.getBleeding((Player)ep).isBleeding()).findFirst()).orElse(null);
        if (this.targetPlayer != null) {
            this.bleeding = PlayerReviveServer.getBleeding((Player)this.targetPlayer);
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)this.targetPlayer, (float)0.5f, (int)2);
        }
        this.useTotemOfUndying(level, maid);
    }

    private void useTotemOfUndying(ServerLevel level, EntityMaid maid) {
        if (!Config.enableReviveTotem) {
            return;
        }
        ItemStack itemstack = InvUtil.tryExtractOneMatches((IItemHandler)maid.getMaidBauble(), stack -> stack.is(Items.TOTEM_OF_UNDYING));
        if (!itemstack.isEmpty()) {
            this.targetPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING), 1);
            CriteriaTriggers.USED_TOTEM.trigger(this.targetPlayer, itemstack);
            this.targetPlayer.setHealth(1.0f);
            this.targetPlayer.removeAllEffects();
            this.targetPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            this.targetPlayer.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            this.targetPlayer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            level.broadcastEntityEvent((Entity)this.targetPlayer, (byte)35);
            PlayerReviveServer.revive((Player)this.targetPlayer);
        }
    }

    private void checkCanReviveAndStartRevive(ServerLevel level, EntityMaid maid) {
        if (PlayerRevive.CONFIG.revive.needReviveItem && PlayerRevive.CONFIG.revive.consumeReviveItem && !this.bleeding.isItemConsumed()) {
            ItemStack extractedForConsume = InvUtil.tryExtractOneMatches((IItemHandler)maid.getAvailableInv(true), arg_0 -> ((CreativeIngredient)PlayerRevive.CONFIG.revive.reviveItem).is(arg_0));
            if (!PlayerRevive.CONFIG.revive.reviveItem.is(extractedForConsume)) {
                this.targetPlayer = null;
                return;
            }
            this.bleeding.setItemConsumed();
        }
        PlayerReviveServer.removePlayerAsHelper((Player)WrappedMaidFakePlayer.get(maid));
        this.bleeding.revivingPlayers().add(WrappedMaidFakePlayer.get(maid));
        this.aggroEntitiesAround(level, maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (this.targetPlayer == null) {
            return false;
        }
        if ((double)this.targetPlayer.distanceTo((Entity)maid) > PlayerRevive.CONFIG.revive.maxDistance) {
            return false;
        }
        return this.bleeding.isBleeding();
    }

    protected void aggroEntitiesAround(ServerLevel level, EntityMaid maid) {
        if (!Config.enableReviveAggro) {
            return;
        }
        List entities = level.getEntities(EntityTypeTest.forClass(Monster.class), AABB.ofSize((Vec3)maid.position(), (double)16.0, (double)16.0, (double)16.0), entity -> true);
        for (Monster entity2 : entities) {
            if (this.aggroEntities.contains(entity2.getUUID())) continue;
            entity2.targetSelector.addGoal(10, (Goal)new TryAttackMaidGoal((Mob)entity2, maid));
            this.aggroEntities.add(entity2.getUUID());
        }
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        super.tick(level, (LivingEntity)maid, p_22553_);
        if (p_22553_ % 20L == 0L) {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)this.targetPlayer, (float)0.5f, (int)2);
        }
        if (!this.startedRevive) {
            if ((double)maid.distanceTo((Entity)this.targetPlayer) < PlayerRevive.CONFIG.revive.maxDistance) {
                this.checkCanReviveAndStartRevive(level, maid);
                this.startedRevive = true;
            }
        } else if (p_22553_ % 20L == 0L) {
            this.aggroEntitiesAround(level, maid);
        }
    }

    protected void stop(ServerLevel p_22548_, EntityMaid maid, long p_22550_) {
        PlayerReviveServer.removePlayerAsHelper((Player)WrappedMaidFakePlayer.get(maid));
        for (UUID uuid : this.aggroEntities) {
            Entity entity = p_22548_.getEntity(uuid);
            if (!(entity instanceof Monster)) continue;
            Monster monster = (Monster)entity;
            if (!entity.isAlive()) continue;
            monster.targetSelector.removeAllGoals(g -> {
                TryAttackMaidGoal tg;
                return g instanceof TryAttackMaidGoal && (tg = (TryAttackMaidGoal)((Object)g)).isMaid(maid);
            });
        }
    }

    protected static class TryAttackMaidGoal
    extends TargetGoal {
        private final EntityMaid maid;

        public TryAttackMaidGoal(Mob p_26140_, EntityMaid maid) {
            super(p_26140_, true);
            this.maid = maid;
        }

        public boolean canUse() {
            return this.mob.canAttack((LivingEntity)this.maid);
        }

        public void start() {
            this.mob.setTarget((LivingEntity)this.maid);
            super.start();
        }

        public boolean isMaid(EntityMaid maid) {
            return maid.getUUID().equals(this.maid.getUUID());
        }
    }
}

