/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import studio.fantasyit.maid_useful_task.memory.BlockUpContext;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.task.IMaidBlockUpTask;
import studio.fantasyit.maid_useful_task.util.Conditions;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;

public class BlockUpDestroyBehavior
extends Behavior<EntityMaid> {
    private BlockUpContext context;
    private IMaidBlockUpTask task;
    WrappedMaidFakePlayer fakePlayer;
    float progress = 0.0f;

    public BlockUpDestroyBehavior(Map<MemoryModuleType<?>, MemoryStatus> p_22528_) {
        super(p_22528_);
    }

    public BlockUpDestroyBehavior() {
        super(Map.of(), 500);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid p_22539_) {
        if (!Conditions.isCurrent(p_22539_, CurrentWork.BLOCKUP_DOWN)) {
            return false;
        }
        if (!MemoryUtil.getBlockUpContext(p_22539_).hasTarget()) {
            return false;
        }
        return MemoryUtil.getBlockUpContext(p_22539_).getStatus() == BlockUpContext.STATUS.DOWN;
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getBlockUpContext(maid).getStatus() != BlockUpContext.STATUS.DOWN) {
            return false;
        }
        return MemoryUtil.getBlockUpContext(maid).isOnLine(maid.blockPosition()) && !maid.blockPosition().equals((Object)this.context.getStartPos());
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        this.context = MemoryUtil.getBlockUpContext(maid);
        this.task = (IMaidBlockUpTask)maid.getTask();
        this.fakePlayer = WrappedMaidFakePlayer.get(maid);
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (!maid.onGround()) {
            this.progress = 0.0f;
        } else {
            this.task.swapValidToolToHand(maid);
            BlockPos targetPos = maid.blockPosition().below();
            maid.swing(InteractionHand.MAIN_HAND);
            MemoryUtil.setLookAt(maid, targetPos);
            float speed = MaidUtils.getDestroyProgressDelta(maid, targetPos);
            this.progress += speed;
            if (this.progress >= 1.0f) {
                MaidUtils.destroyBlock(maid, targetPos);
                this.progress = 0.0f;
            }
        }
    }

    protected void stop(ServerLevel p_22548_, EntityMaid maid, long p_22550_) {
        super.stop(p_22548_, (LivingEntity)maid, p_22550_);
        this.context.clearStartTarget();
        MemoryUtil.clearTarget(maid);
        MemoryUtil.setCurrent(maid, CurrentWork.IDLE);
    }
}

