/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_useful_task.memory.BlockUpContext;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.task.IMaidBlockUpTask;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class BlockUpScheduleBehavior
extends Behavior<EntityMaid> {
    public BlockUpScheduleBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid p_22539_) {
        switch (MemoryUtil.getCurrent(p_22539_)) {
            case BLOCKUP_UP: 
            case BLOCKUP_DOWN: 
            case BLOCKUP_DESTROY: 
            case IDLE: {
                break;
            }
            default: {
                return false;
            }
        }
        return super.checkExtraStartConditions(p_22538_, (LivingEntity)p_22539_);
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        BlockUpContext context = MemoryUtil.getBlockUpContext(maid);
        IMaidBlockUpTask task = (IMaidBlockUpTask)maid.getTask();
        if (context.hasTarget()) {
            if (context.getStatus() != BlockUpContext.STATUS.UP && !context.isOnLine(maid.blockPosition())) {
                context.clearStartTarget();
                MemoryUtil.setCurrent(maid, CurrentWork.IDLE);
            } else if (context.getStatus() != BlockUpContext.STATUS.IDLE && MemoryUtil.getTargetPos(maid) == null) {
                if (context.getStatus() == BlockUpContext.STATUS.DOWN) {
                    MemoryUtil.setTarget(maid, context.getTargetPos(), 0.5f);
                    MemoryUtil.setCurrent(maid, CurrentWork.BLOCKUP_DOWN);
                } else if (maid.canPathReach(context.getStartPos())) {
                    MemoryUtil.setTarget(maid, context.getStartPos(), 0.5f);
                    MemoryUtil.setCurrent(maid, CurrentWork.BLOCKUP_UP);
                } else {
                    context.clearStartTarget();
                }
            } else if (!context.isOnLine(maid.blockPosition()) || context.getStartPos().equals((Object)context.getTargetPos())) {
                context.clearStartTarget();
                MemoryUtil.setCurrent(maid, CurrentWork.IDLE);
            } else if (context.getStatus() == BlockUpContext.STATUS.IDLE && !task.stillValid(maid, maid.blockPosition())) {
                maid.getBrain().setMemory((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(context.getTargetPos()));
                context.setStatus(BlockUpContext.STATUS.DOWN);
                MemoryUtil.setCurrent(maid, CurrentWork.BLOCKUP_DOWN);
            }
        } else {
            Pair<BlockPos, BlockPos> targetPosBlockUp = task.findTargetPosBlockUp(maid, MaidUtils.getMaidRestrictCenter(maid), task.countMaxUsableBlockItems(maid));
            if (targetPosBlockUp != null) {
                context.setStartTarget((BlockPos)targetPosBlockUp.getA(), (BlockPos)targetPosBlockUp.getB());
                maid.getBrain().setMemory((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker((BlockPos)targetPosBlockUp.getA()));
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)((BlockPos)targetPosBlockUp.getA()), (float)0.5f, (int)0);
                context.setStatus(BlockUpContext.STATUS.UP);
                MemoryUtil.setCurrent(maid, CurrentWork.BLOCKUP_UP);
            }
        }
    }
}

