/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_useful_task.memory.BlockTargetMemory;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_useful_task.task.IMaidBlockDestroyTask;
import studio.fantasyit.maid_useful_task.util.Conditions;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;

public class DestoryBlockBehavior
extends Behavior<EntityMaid> {
    private IMaidBlockDestroyTask task;
    List<BlockPos> blockPosSet = null;
    int index = 0;
    float destroyProgress = 0.0f;
    BlockPos targetPos;
    BlockState targetBlockState;
    WrappedMaidFakePlayer fakePlayer;

    public DestoryBlockBehavior() {
        super(Map.of((MemoryModuleType)InitEntities.TARGET_POS.get(), MemoryStatus.VALUE_PRESENT, (MemoryModuleType)MemoryModuleRegistry.DESTROY_TARGET.get(), MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (!Conditions.isCurrent(maid, CurrentWork.DESTROY) && !Conditions.isCurrent(maid, CurrentWork.BLOCKUP_DESTROY)) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid, 1.0f);
    }

    protected void start(ServerLevel p_22540_, @NotNull EntityMaid maid, long p_22542_) {
        super.start(p_22540_, (LivingEntity)maid, p_22542_);
        BlockTargetMemory blockTargetMemory = MemoryUtil.getDestroyTargetMemory(maid);
        if (blockTargetMemory != null) {
            this.blockPosSet = new ArrayList<BlockPos>(blockTargetMemory.getBlockPosSet());
            this.blockPosSet.sort((o1, o2) -> (int)(o1.distSqr((Vec3i)maid.blockPosition().above()) - o2.distSqr((Vec3i)maid.blockPosition().above())));
        }
        this.index = 0;
        this.task = (IMaidBlockDestroyTask)maid.getTask();
        this.fakePlayer = WrappedMaidFakePlayer.get(maid);
        this.targetPos = null;
        this.targetBlockState = null;
        maid.getNavigation().stop();
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid p_22546_, long p_22547_) {
        if (MemoryUtil.getCurrent(p_22546_) != CurrentWork.DESTROY && MemoryUtil.getCurrent(p_22546_) != CurrentWork.BLOCKUP_DESTROY) {
            return false;
        }
        return this.blockPosSet != null && this.index < this.blockPosSet.size() || this.targetPos != null;
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22553_) {
        if (!Conditions.stopAndCheckStopped(maid)) {
            return;
        }
        if (this.targetPos != null) {
            this.tickDestroyProgress(maid);
            return;
        }
        while (this.index < this.blockPosSet.size()) {
            this.targetPos = this.blockPosSet.get(this.index++);
            this.targetBlockState = level.getBlockState(this.targetPos);
            if (!this.targetBlockState.isAir()) {
                this.task.tryTakeOutToolForTarget(maid, this.targetPos);
                if (this.task.canDestroyBlock(maid, this.targetPos)) {
                    this.destroyProgress = 0.0f;
                    return;
                }
            }
            this.targetPos = null;
            this.targetBlockState = null;
        }
    }

    private void tickDestroyProgress(EntityMaid maid) {
        float speed = MaidUtils.getDestroyProgressDelta(maid, this.targetPos);
        MemoryUtil.setLookAt(maid, this.targetPos);
        if (speed != 0.0f && this.task.availableToGetDrop(maid, this.fakePlayer, this.targetPos, this.targetBlockState)) {
            maid.swing(InteractionHand.MAIN_HAND);
            this.destroyProgress += speed;
            if (this.destroyProgress >= 1.0f) {
                this.task.tryDestroyBlock(maid, this.targetPos);
                this.destroyProgress = 0.0f;
                this.targetPos = null;
                this.targetBlockState = null;
            }
        } else {
            this.targetPos = null;
            this.targetBlockState = null;
        }
    }

    protected void stop(ServerLevel p_22548_, EntityMaid p_22549_, long p_22550_) {
        super.stop(p_22548_, (LivingEntity)p_22549_, p_22550_);
        MemoryUtil.clearDestroyTargetMemory(p_22549_);
        MemoryUtil.clearTarget(p_22549_);
        MemoryUtil.setCurrent(p_22549_, CurrentWork.IDLE);
    }

    protected boolean timedOut(long p_22537_) {
        return false;
    }
}

