/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.behavior.common.MaidCenterMoveToBlockTask;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.task.IMaidBlockDestroyTask;
import studio.fantasyit.maid_useful_task.util.Conditions;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;
import studio.fantasyit.maid_useful_task.util.PosUtils;

public class DestoryBlockMoveBehavior
extends MaidCenterMoveToBlockTask {
    private IMaidBlockDestroyTask task;
    private MaidPathFindingBFS pathfindingBFS;
    private BlockPos targetPos;
    List<BlockPos> blockPosSet;

    public DestoryBlockMoveBehavior() {
        super(0.5f, 7, 8);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (!Conditions.isCurrent(maid, CurrentWork.IDLE) && !Conditions.isCurrent(maid, CurrentWork.BLOCKUP_DESTROY)) {
            return false;
        }
        return super.checkExtraStartConditions(p_22538_, (LivingEntity)maid);
    }

    protected void start(@NotNull ServerLevel p_22540_, @NotNull EntityMaid maid, long p_22542_) {
        super.start(p_22540_, (LivingEntity)maid, p_22542_);
        if (maid.hasRestriction()) {
            this.setSearchRange((int)maid.getRestrictRadius());
        }
        this.task = (IMaidBlockDestroyTask)maid.getTask();
        this.task.tryTakeOutTool(maid);
        this.searchForDestination(p_22540_, maid);
        @Nullable BlockPos target = MemoryUtil.getTargetPos(maid);
        if (target != null && this.blockPosSet != null) {
            this.blockPosSet.addAll(this.task.getTryDestroyBlockListBesidesStart(this.targetPos, target, maid));
            MemoryUtil.setDestroyTargetMemory(maid, this.blockPosSet);
            if (Conditions.isCurrent(maid, CurrentWork.IDLE)) {
                MemoryUtil.setCurrent(maid, CurrentWork.DESTROY);
            }
        }
    }

    @Override
    protected boolean shouldMoveTo(@NotNull ServerLevel serverLevel, @NotNull EntityMaid entityMaid, @NotNull BlockPos blockPos) {
        if (!this.task.shouldDestroyBlock(entityMaid, blockPos.immutable())) {
            return false;
        }
        this.targetPos = blockPos.immutable();
        BlockPos startPos = entityMaid.blockPosition();
        if (blockPos instanceof BlockPos.MutableBlockPos) {
            BlockPos.MutableBlockPos mb = (BlockPos.MutableBlockPos)blockPos;
            int dx = 0;
            while (dx < this.task.reachDistance()) {
                int dy = 0;
                while (dy < this.task.reachDistance()) {
                    int dz = 0;
                    while (dz < this.task.reachDistance()) {
                        BlockPos pos = mb.offset(dx, dy, dz);
                        if (PosUtils.isSafePos((Level)serverLevel, pos) && Conditions.isGlobalValidTarget(entityMaid, pos, this.targetPos) && !(pos.distSqr((Vec3i)this.targetPos) > (double)(this.task.reachDistance() * this.task.reachDistance())) && Math.abs(startPos.getY() - pos.getY()) < this.task.reachDistance() && Math.abs(startPos.getX() - pos.getX()) < this.task.reachDistance() && Math.abs(startPos.getZ() - pos.getZ()) < this.task.reachDistance() && (pos.equals((Object)entityMaid.blockPosition()) || entityMaid.isWithinRestriction(pos) && this.pathfindingBFS.canPathReach(pos))) {
                            this.blockPosSet = this.task.toDestroyFromStanding(entityMaid, this.targetPos, pos);
                            if (this.blockPosSet != null) {
                                mb.set((Vec3i)pos);
                                return true;
                            }
                        }
                        dz = dz <= 0 ? 1 - dz : -dz;
                    }
                    dy = dy <= 0 ? 1 - dy : -dy;
                }
                dx = dx <= 0 ? 1 - dx : -dx;
            }
        }
        this.targetPos = null;
        return false;
    }

    @Override
    @NotNull
    protected MaidPathFindingBFS getOrCreateArrivalMap(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (this.pathfindingBFS == null) {
            this.pathfindingBFS = maid.hasRestriction() ? new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), worldIn, maid, (float)((int)maid.getRestrictRadius() + 1), this.task.reachDistance() + 2) : new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), worldIn, maid, (float)(this.task.reachDistance() + 1), this.task.reachDistance() + 2);
        }
        return this.pathfindingBFS;
    }

    @Override
    protected void clearCurrentArrivalMap(MaidPathFindingBFS pathFinding) {
        super.clearCurrentArrivalMap(pathFinding);
        this.pathfindingBFS = null;
    }
}

