/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import studio.fantasyit.maid_useful_task.task.IMaidFindTargetTask;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class FindTargetMoveBehavior
extends Behavior<EntityMaid> {
    public FindTargetMoveBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        IMaidFindTargetTask task = (IMaidFindTargetTask)maid.getTask();
        if (task.findTarget(p_22538_, maid) == null) {
            return false;
        }
        if (maid.hasRestriction()) {
            return false;
        }
        LivingEntity owner = maid.getOwner();
        return owner != null && maid.distanceTo((Entity)owner) < (float)task.minReScheduleDistance();
    }

    protected void start(ServerLevel serverlevel, EntityMaid maid, long p_22542_) {
        IMaidFindTargetTask task = (IMaidFindTargetTask)maid.getTask();
        LivingEntity owner = maid.getOwner();
        if (owner == null) {
            return;
        }
        BlockPos target = task.findTarget(serverlevel, maid);
        if (target != null) {
            if (maid.distanceToSqr(target.getCenter()) < 9.0) {
                maid.getJumpControl().jump();
                return;
            }
            BlockPos finalTarget = target;
            BlockPos ownerPos = owner.blockPosition();
            BlockPos maidPos = maid.blockPosition();
            if (finalTarget.distSqr((Vec3i)ownerPos) > (double)(task.maxOutDistance() * task.maxOutDistance())) {
                Vec3 dVec = target.getCenter().subtract(owner.position());
                dVec = dVec.normalize().scale((double)task.maxOutDistance() - (double)(task.maxOutDistance() - task.minReScheduleDistance()) / 2.0);
                BlockPos fTarget = maidPos.offset((int)dVec.x, (int)dVec.y, (int)dVec.z);
                int x = 0;
                while (x < 3) {
                    int z = 0;
                    while (z < 3) {
                        int y = 0;
                        while (!serverlevel.getBlockState(fTarget.offset(x, y, z)).isAir()) {
                            ++y;
                        }
                        while (!serverlevel.getBlockState(fTarget.offset(x, y, z)).isAir()) {
                            --y;
                        }
                        if (fTarget.offset(x, y, z).distSqr((Vec3i)ownerPos) < (double)(task.maxOutDistance() * task.maxOutDistance())) {
                            finalTarget = fTarget.offset(x, y, z);
                        }
                        z = z <= 0 ? 1 - z : -z;
                    }
                    x = x <= 0 ? 1 - x : -x;
                }
            }
            if (finalTarget.distSqr((Vec3i)maidPos) < (double)(task.maxOutDistance() * task.maxOutDistance())) {
                double distanceToOwner = maidPos.distSqr((Vec3i)ownerPos);
                double speed = 0.4;
                if (distanceToOwner < 16.0) {
                    speed = 0.5;
                }
                if (distanceToOwner < 9.0) {
                    speed = 0.64;
                }
                MemoryUtil.setTarget(maid, finalTarget, (float)speed);
            }
        }
    }
}

