/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.task.IMaidBlockDestroyTask;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class MaidSelfRescueBehavior
extends Behavior<EntityMaid> {
    boolean started = false;

    public MaidSelfRescueBehavior() {
        super(Map.of(), 600);
    }

    private static boolean isNotSafeAndCanTryToDestroy(ServerLevel level, EntityMaid maid, BlockPos pos, IMaidBlockDestroyTask task) {
        BlockState bs = level.getBlockState(pos);
        if (bs.isAir()) {
            return false;
        }
        VoxelShape collision = bs.getCollisionShape((BlockGetter)level, pos);
        if (collision.isEmpty()) {
            return false;
        }
        return maid.getBoundingBox().intersects(collision.bounds().move(pos)) && bs.isSuffocating((BlockGetter)level, pos) && task.mayDestroy(maid, pos);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (!Config.enableSelfRescue) {
            return false;
        }
        IMaidTask iMaidTask = maid.getTask();
        if (!(iMaidTask instanceof IMaidBlockDestroyTask)) {
            return false;
        }
        IMaidBlockDestroyTask ibdt = (IMaidBlockDestroyTask)iMaidTask;
        return MaidSelfRescueBehavior.isNotSafeAndCanTryToDestroy(level, maid, maid.blockPosition(), ibdt) || MaidSelfRescueBehavior.isNotSafeAndCanTryToDestroy(level, maid, maid.blockPosition().above(), ibdt);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid p_22546_, long p_22547_) {
        return this.started && this.checkExtraStartConditions(p_22545_, p_22546_);
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        this.started = false;
        if (MemoryUtil.getCurrent(maid) == CurrentWork.DESTROY) {
            MemoryUtil.setCurrent(maid, CurrentWork.IDLE);
            return;
        }
        if (MemoryUtil.getDestroyTargetMemory(maid) != null) {
            return;
        }
        IMaidTask iMaidTask = maid.getTask();
        if (!(iMaidTask instanceof IMaidBlockDestroyTask)) {
            return;
        }
        IMaidBlockDestroyTask task = (IMaidBlockDestroyTask)iMaidTask;
        this.started = true;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (MaidSelfRescueBehavior.isNotSafeAndCanTryToDestroy(p_22540_, maid, maid.blockPosition(), task)) {
            list.add(maid.blockPosition());
        }
        if (MaidSelfRescueBehavior.isNotSafeAndCanTryToDestroy(p_22540_, maid, maid.blockPosition().above(), task)) {
            list.add(maid.blockPosition().above());
        }
        MemoryUtil.setDestroyTargetMemory(maid, list);
        MemoryUtil.setTarget(maid, maid.blockPosition(), 0.5f);
        MemoryUtil.setCurrent(maid, CurrentWork.DESTROY);
    }

    protected void stop(ServerLevel p_22548_, EntityMaid p_22549_, long p_22550_) {
        MemoryUtil.clearTarget(p_22549_);
        MemoryUtil.setCurrent(p_22549_, CurrentWork.IDLE);
    }
}

