/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_useful_task.task.IMaidBlockPlaceTask;
import studio.fantasyit.maid_useful_task.util.Conditions;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class PlaceBlockBehavior
extends Behavior<EntityMaid> {
    private BlockPos target;

    public PlaceBlockBehavior() {
        super(Map.of((MemoryModuleType)MemoryModuleRegistry.PLACE_TARGET.get(), MemoryStatus.VALUE_PRESENT, (MemoryModuleType)InitEntities.TARGET_POS.get(), MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        MemoryUtil.setCurrent(maid, CurrentWork.PLACE);
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid p_22546_, long p_22547_) {
        return this.target != null;
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        super.start(p_22540_, (LivingEntity)maid, p_22542_);
        this.target = MemoryUtil.getPlaceTarget(maid);
        if (this.target == null) {
            return;
        }
        MemoryUtil.setLookAt(maid, this.target);
        maid.getNavigation().stop();
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!Conditions.stopAndCheckStopped(maid)) {
            return;
        }
        IMaidBlockPlaceTask task = (IMaidBlockPlaceTask)maid.getTask();
        if (task.shouldPlacePos(maid, maid.getMainHandItem(), this.target)) {
            maid.swing(InteractionHand.MAIN_HAND);
            task.tryPlaceBlock(maid, this.target);
        }
        this.target = null;
    }

    protected void stop(ServerLevel p_22548_, EntityMaid p_22549_, long p_22550_) {
        super.stop(p_22548_, (LivingEntity)p_22549_, p_22550_);
        MemoryUtil.clearPlaceTarget(p_22549_);
        MemoryUtil.clearTarget(p_22549_);
        MemoryUtil.setCurrent(p_22549_, CurrentWork.IDLE);
    }
}

