/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.behavior.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.behavior.common.MaidCenterMoveToBlockTask;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.task.IMaidBlockPlaceTask;
import studio.fantasyit.maid_useful_task.util.Conditions;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class PlaceBlockMoveBehavior
extends MaidCenterMoveToBlockTask {
    private IMaidBlockPlaceTask task;
    private MaidPathFindingBFS pathfindingBFS;
    private BlockPos targetPos;
    private ItemStack targetItem;

    public PlaceBlockMoveBehavior() {
        super(0.5f, 4);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (!Conditions.isCurrent(maid, CurrentWork.IDLE)) {
            return false;
        }
        return super.checkExtraStartConditions(p_22538_, (LivingEntity)maid);
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        super.start(p_22540_, (LivingEntity)maid, p_22542_);
        if (maid.hasRestriction()) {
            this.setSearchRange((int)maid.getRestrictRadius());
        }
        this.task = (IMaidBlockPlaceTask)maid.getTask();
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        ArrayList<ItemStack> markedVis = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!this.task.shouldPlaceItemStack(maid, inv.getStackInSlot(i))) continue;
            int finalI = i;
            if (markedVis.stream().anyMatch(t -> ItemStack.isSameItem((ItemStack)t, (ItemStack)inv.getStackInSlot(finalI)))) continue;
            this.targetItem = inv.getStackInSlot(i);
            this.searchForDestination(p_22540_, maid);
            @Nullable BlockPos target = MemoryUtil.getTargetPos(maid);
            if (target != null) {
                MemoryUtil.setPlaceTarget(maid, this.targetPos);
                MemoryUtil.setCurrent(maid, CurrentWork.PLACE);
                inv.setStackInSlot(finalI, maid.getMainHandItem());
                maid.setItemInHand(InteractionHand.MAIN_HAND, this.targetItem);
                return;
            }
            markedVis.add(this.targetItem);
        }
    }

    @Override
    protected boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, BlockPos blockPos) {
        if (!this.task.shouldPlacePos(entityMaid, this.targetItem, blockPos.immutable())) {
            return false;
        }
        if (!entityMaid.isWithinRestriction(blockPos)) {
            return false;
        }
        this.targetPos = blockPos.immutable();
        if (blockPos instanceof BlockPos.MutableBlockPos) {
            int[] dv;
            BlockPos.MutableBlockPos mb = (BlockPos.MutableBlockPos)blockPos;
            for (int dx : dv = new int[]{0, 1, -1}) {
                for (int dy : dv) {
                    for (int dz : dv) {
                        BlockPos pos = mb.offset(dx, dy, dz);
                        if (!Conditions.isGlobalValidTarget(entityMaid, pos, this.targetPos) || !entityMaid.isWithinRestriction(pos) || !this.pathfindingBFS.canPathReach(pos)) continue;
                        mb.set((Vec3i)pos);
                        return true;
                    }
                }
            }
        }
        this.targetPos = null;
        return false;
    }

    @Override
    @NotNull
    protected MaidPathFindingBFS getOrCreateArrivalMap(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (this.pathfindingBFS == null) {
            this.pathfindingBFS = maid.hasRestriction() ? new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), worldIn, maid, (float)((int)maid.getRestrictRadius()), 9) : new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), worldIn, maid, 7.0f, 9);
        }
        return this.pathfindingBFS;
    }

    @Override
    protected void clearCurrentArrivalMap(MaidPathFindingBFS pathFinding) {
        super.clearCurrentArrivalMap(pathFinding);
        this.pathfindingBFS = null;
    }
}

