/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.data;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import studio.fantasyit.maid_useful_task.data.IConfigSetter;

public class MaidLoggingConfig
implements TaskDataKey<Data> {
    public static TaskDataKey<Data> KEY = null;
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"logging");

    public static Data get(EntityMaid maid) {
        return (Data)maid.getOrCreateData(KEY, (Object)Data.getDefault());
    }

    public ResourceLocation getKey() {
        return LOCATION;
    }

    public CompoundTag writeSaveData(Data data) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("plant", data.plant);
        tag.putBoolean("blockUp", data.blockUp);
        tag.putBoolean("skipNonNature", data.skipNonNature);
        return tag;
    }

    public Data readSaveData(CompoundTag compound) {
        boolean plant = compound.getBoolean("plant");
        boolean blockUp = compound.getBoolean("blockUp");
        boolean skipNonNature = compound.getBoolean("skipNonNature");
        return new Data(plant, blockUp, skipNonNature);
    }

    public static final class Data
    implements IConfigSetter {
        private boolean plant;
        private boolean blockUp;
        private boolean skipNonNature;

        public Data(boolean plant, boolean blockUp, boolean skipNonNature) {
            this.plant = plant;
            this.blockUp = blockUp;
            this.skipNonNature = skipNonNature;
        }

        public static Data getDefault() {
            return new Data(true, true, true);
        }

        public boolean plant() {
            return this.plant;
        }

        public void plant(boolean plant) {
            this.plant = plant;
        }

        public boolean blockUp() {
            return this.blockUp;
        }

        public void blockUp(boolean blockUp) {
            this.blockUp = blockUp;
        }

        public boolean skipNonNature() {
            return this.skipNonNature;
        }

        public void skipNonNature(boolean skipNonNature) {
            this.skipNonNature = skipNonNature;
        }

        @Override
        public void setConfigValue(String name, String value) {
            switch (name) {
                case "plant": {
                    this.plant = Boolean.parseBoolean(value);
                    break;
                }
                case "blockUp": {
                    this.blockUp = Boolean.parseBoolean(value);
                    break;
                }
                case "skipNonNature": {
                    this.skipNonNature = Boolean.parseBoolean(value);
                }
            }
        }
    }
}

