/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;

public class BlockUpContext {
    public static final Codec<BlockUpContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("startPos").forGetter(BlockUpContext::getOptionalStartPos), (App)BlockPos.CODEC.optionalFieldOf("targetPos").forGetter(BlockUpContext::getOptionalTargetPos)).apply((Applicative)instance, BlockUpContext::new));
    boolean isGoingDown = false;
    BlockPos targetPos;
    BlockPos startPos;
    private STATUS status = STATUS.IDLE;

    public BlockUpContext() {
        this(Optional.empty(), Optional.empty());
    }

    public BlockUpContext(BlockPos startPos, BlockPos targetPos) {
        this.startPos = startPos;
        this.targetPos = targetPos;
    }

    public BlockUpContext(Optional<BlockPos> startPos, Optional<BlockPos> targetPos) {
        this.startPos = startPos.orElse(null);
        this.targetPos = targetPos.orElse(null);
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public Optional<BlockPos> getOptionalStartPos() {
        return Optional.ofNullable(this.startPos);
    }

    public Optional<BlockPos> getOptionalTargetPos() {
        return Optional.ofNullable(this.targetPos);
    }

    public boolean isOnLine(BlockPos pos) {
        return pos.getX() == this.startPos.getX() && pos.getZ() == this.startPos.getZ() && pos.getY() >= this.startPos.getY() && pos.getY() <= this.targetPos.getY();
    }

    public void setStartTarget(BlockPos startPos, BlockPos targetPos) {
        this.startPos = startPos;
        this.targetPos = targetPos;
        this.setStatus(STATUS.IDLE);
    }

    public void clearStartTarget() {
        this.startPos = null;
        this.targetPos = null;
        this.setStatus(STATUS.IDLE);
    }

    public boolean hasTarget() {
        return this.startPos != null && this.targetPos != null;
    }

    public boolean isTarget(BlockPos pos) {
        return pos.equals((Object)this.targetPos);
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public static enum STATUS {
        IDLE,
        DOWN,
        UP;

    }
}

