/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class BlockValidationMemory {
    public static final Codec<BlockValidationMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)BlockPos.CODEC).fieldOf("validList").forGetter(BlockValidationMemory::getValidList), (App)Codec.list((Codec)BlockPos.CODEC).fieldOf("invalidList").forGetter(BlockValidationMemory::getInvalidList)).apply((Applicative)instance, BlockValidationMemory::new));
    private final Set<BlockPos> validSet = new HashSet<BlockPos>();
    private final Set<BlockPos> invalidSet = new HashSet<BlockPos>();

    public BlockValidationMemory() {
    }

    public BlockValidationMemory(List<BlockPos> validList, List<BlockPos> invalidList) {
        this.validSet.addAll(validList);
        this.invalidSet.addAll(invalidList);
    }

    public List<BlockPos> getValidList() {
        return List.copyOf(this.validSet);
    }

    public List<BlockPos> getInvalidList() {
        return List.copyOf(this.invalidSet);
    }

    public void setValid(BlockPos blockPos) {
        this.validSet.add(blockPos);
        this.invalidSet.remove(blockPos);
    }

    public void setInvalid(BlockPos blockPos) {
        this.invalidSet.add(blockPos);
        this.validSet.remove(blockPos);
    }

    public void remove(BlockPos blockPos) {
        this.validSet.remove(blockPos);
        this.invalidSet.remove(blockPos);
    }

    public boolean isValid(BlockPos blockPos, boolean defaultValue) {
        if (this.validSet.contains(blockPos)) {
            return true;
        }
        if (this.invalidSet.contains(blockPos)) {
            return false;
        }
        return defaultValue;
    }

    public boolean hasRecord(BlockPos blockPos) {
        return this.validSet.contains(blockPos) || this.invalidSet.contains(blockPos);
    }

    public void clearFaraway(BlockPos blockPos, int range) {
        this.clearIf(pos -> pos.distSqr((Vec3i)blockPos) > (double)(range * range));
    }

    public void clearIf(Predicate<BlockPos> o) {
        this.validSet.removeIf(o);
        this.invalidSet.removeIf(o);
    }
}

