/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.network;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.data.IConfigSetter;
import studio.fantasyit.maid_useful_task.data.MaidConfigKeys;

public class MaidConfigurePacket
implements CustomPacketPayload {
    public final int maidId;
    public final String name;
    public final String value;
    public final ResourceLocation key;
    public static final CustomPacketPayload.Type<MaidConfigurePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"maid_config"));
    public static Codec<MaidConfigurePacket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("maidId").forGetter(packet -> packet.maidId), (App)ResourceLocation.CODEC.fieldOf("key").forGetter(packet -> packet.key), (App)Codec.STRING.fieldOf("name").forGetter(packet -> packet.name), (App)Codec.STRING.fieldOf("value").forGetter(packet -> packet.value)).apply((Applicative)instance, MaidConfigurePacket::new));
    public static StreamCodec<ByteBuf, MaidConfigurePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, t -> t.maidId, (StreamCodec)ResourceLocation.STREAM_CODEC, t -> t.key, (StreamCodec)ByteBufCodecs.STRING_UTF8, t -> t.name, (StreamCodec)ByteBufCodecs.STRING_UTF8, t -> t.value, MaidConfigurePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public MaidConfigurePacket(int maidId, ResourceLocation key, String name, String value) {
        this.maidId = maidId;
        this.key = key;
        this.name = name;
        this.value = value;
    }

    public static void send(EntityMaid maid, ResourceLocation key, String name, String value) {
        PacketDistributor.sendToServer((CustomPacketPayload)new MaidConfigurePacket(maid.getId(), key, name, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handle(MaidConfigurePacket msg, IPayloadContext context) {
        EntityMaid entityMaid;
        Object t;
        @Nullable ServerPlayer sender = (ServerPlayer)context.player();
        Entity entity = sender.level().getEntity(msg.maidId);
        if (entity instanceof EntityMaid && (t = MaidConfigKeys.getValue(entityMaid = (EntityMaid)entity, msg.key)) instanceof IConfigSetter) {
            IConfigSetter ics = (IConfigSetter)t;
            ics.setConfigValue(msg.name, msg.value);
        }
    }
}

