/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.network;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import studio.fantasyit.maid_useful_task.vehicle.MaidVehicleManager;

public class MaidSyncVehiclePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<MaidSyncVehiclePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"sync_vehicle"));
    final CompoundTag tag;
    final int maidId;
    public static Codec<MaidSyncVehiclePacket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("maidId").forGetter(packet -> packet.maidId), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(packet -> packet.tag)).apply((Applicative)instance, MaidSyncVehiclePacket::new));
    public static StreamCodec<RegistryFriendlyByteBuf, MaidSyncVehiclePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, t -> t.maidId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, t -> t.tag, MaidSyncVehiclePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public MaidSyncVehiclePacket(int maidId, CompoundTag tag) {
        this.maidId = maidId;
        this.tag = tag;
    }

    public static void handle(MaidSyncVehiclePacket msg, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(msg.maidId);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            MaidVehicleManager.getControllableVehicle(maid).ifPresent(vehicle -> vehicle.syncVehicleParameter(maid, msg.tag));
        }
    }
}

