/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.behavior.common.DestoryBlockBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.DestoryBlockMoveBehavior;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;

public interface IMaidBlockDestroyTask {
    @Nullable
    default public List<BlockPos> toDestroyFromStanding(EntityMaid maid, BlockPos targetPos, BlockPos standPos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        Vec3 eyePos = standPos.getCenter().add(0.0, (double)maid.getEyeHeight() - 0.5, 0.0);
        Boolean available = (Boolean)BlockGetter.traverseBlocks((Vec3)eyePos, (Vec3)targetPos.getCenter(), (Object)maid.level(), (level, pos) -> {
            if (pos.distSqr((Vec3i)standPos) > (double)(this.reachDistance() * this.reachDistance())) {
                return false;
            }
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                return null;
            }
            if (this.mayDestroy(maid, (BlockPos)pos)) {
                list.add(pos.immutable());
                return null;
            }
            return false;
        }, a -> true);
        if (available.booleanValue()) {
            return list;
        }
        return null;
    }

    default public List<BlockPos> getTryDestroyBlockListBesidesStart(BlockPos startPos, BlockPos standPos, EntityMaid maid) {
        HashSet<BlockPos> marked = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int[] dv = new int[]{0, 1, -1};
        int maxDXZ = 2;
        queue.add(startPos);
        marked.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            for (int dx : dv) {
                for (int dy : dv) {
                    for (int dz : dv) {
                        List<BlockPos> targetList;
                        BlockPos target;
                        if (dx == 0 && dy == 0 && dz == 0 || (target = pos.offset(dx, dy, dz)).distSqr((Vec3i)standPos) > (double)(this.reachDistance() * this.reachDistance()) || marked.contains(target) || !this.shouldDestroyBlock(maid, target) || (targetList = this.toDestroyFromStanding(maid, target, standPos)) == null) continue;
                        marked.add(target);
                        result.addAll(targetList);
                        queue.add(target);
                    }
                }
            }
        }
        return result;
    }

    public boolean shouldDestroyBlock(EntityMaid var1, BlockPos var2);

    public boolean mayDestroy(EntityMaid var1, BlockPos var2);

    default public boolean canDestroyBlock(EntityMaid maid, BlockPos pos) {
        return !(maid.distanceToSqr(pos.getCenter()) > Math.pow(this.reachDistance() + 1, 2.0));
    }

    default public boolean tryDestroyBlock(EntityMaid maid, BlockPos blockPos) {
        return MaidUtils.destroyBlock(maid, blockPos);
    }

    default public void tryTakeOutTool(EntityMaid maid) {
    }

    default public void tryTakeOutToolForTarget(EntityMaid maid, BlockPos pos) {
        this.tryTakeOutTool(maid);
    }

    default public boolean availableToGetDrop(EntityMaid maid, WrappedMaidFakePlayer fakePlayer, BlockPos pos, BlockState targetBlockState) {
        return fakePlayer.hasCorrectToolForDrops(targetBlockState);
    }

    default public int reachDistance() {
        return 7;
    }

    @NotNull
    default public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(@NotNull EntityMaid entityMaid) {
        return List.of(Pair.of((Object)5, (Object)((Object)new DestoryBlockBehavior())), Pair.of((Object)4, (Object)((Object)new DestoryBlockMoveBehavior())));
    }
}

