/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_useful_task.task.IMaidBlockDestroyTask;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.PosUtils;

public interface IMaidBlockUpTask {
    default public boolean isFindingBlock(EntityMaid maid, BlockPos target, BlockPos standPos) {
        if (target.distSqr((Vec3i)standPos) > (double)(this.touchLimit() * this.touchLimit())) {
            return false;
        }
        IMaidTask task = maid.getTask();
        if (task instanceof IMaidBlockDestroyTask) {
            IMaidBlockDestroyTask destroyTask = (IMaidBlockDestroyTask)task;
            return destroyTask.shouldDestroyBlock(maid, target);
        }
        return false;
    }

    default public boolean stillValid(EntityMaid maid, BlockPos startPos) {
        int dx = 0;
        while (dx < this.touchLimit()) {
            int dz = 0;
            while (dz < this.touchLimit()) {
                for (int dy = 0; dy < this.verticalDistance(); ++dy) {
                    BlockPos targetPos = startPos.offset(dx, dy, dz);
                    if (!this.isFindingBlock(maid, targetPos, startPos)) continue;
                    return true;
                }
                dz = dz <= 0 ? 1 - dz : -dz;
            }
            dx = dx <= 0 ? 1 - dx : -dx;
        }
        return false;
    }

    default public Pair<BlockPos, BlockPos> findTargetPosBlockUp(EntityMaid maid, BlockPos center, int maxUp) {
        ServerLevel level = (ServerLevel)maid.level();
        int maxHeight = this.verticalOffset() + this.verticalDistance();
        boolean hasRestriction = maid.hasRestriction();
        BlockPos restrictCenter = maid.getRestrictCenter();
        float restrictRadius = maid.getRestrictRadius();
        int scanRange = this.scanRange(maid);
        Function<BlockPos, Boolean> withinRestriction = pos -> {
            if (hasRestriction) {
                return restrictCenter.distSqr((Vec3i)pos) < (double)(restrictRadius * restrictRadius);
            }
            return true;
        };
        CenterOffsetBlockPosSet notAvailable = new CenterOffsetBlockPosSet(scanRange, scanRange + maxHeight / 2 + 1, scanRange, center.getX(), center.getY() + maxHeight / 2, center.getZ());
        MaidPathFindingBFS pathFindingBFS = new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), level, maid, 7.0f, scanRange + 2);
        int dx = 0;
        while (dx < scanRange) {
            int dz = 0;
            while (dz < scanRange) {
                BlockPos.MutableBlockPos ground = center.offset(dx, 0, dz).mutable();
                while (level.getBlockState((BlockPos)ground).canBeReplaced()) {
                    ground.move(0, -1, 0);
                }
                while (!level.getBlockState((BlockPos)ground).canBeReplaced()) {
                    ground.move(0, 1, 0);
                }
                if (!notAvailable.isVis((BlockPos)ground) && PosUtils.isSafePos((Level)level, (BlockPos)ground) && PosUtils.isFourSideAir((BlockGetter)level, ground.immutable()) && pathFindingBFS.canPathReach((BlockPos)ground)) {
                    BlockPos targetPos;
                    int dy;
                    boolean valid = true;
                    for (dy = 0; dy < this.verticalOffset(); ++dy) {
                        targetPos = ground.above(dy);
                        if (level.getBlockState(targetPos).canBeReplaced()) continue;
                        valid = false;
                        break;
                    }
                    for (dy = this.verticalOffset(); dy < this.verticalOffset() + 2; ++dy) {
                        targetPos = ground.above(dy);
                        if (level.getBlockState(targetPos).isAir()) continue;
                        valid = false;
                        break;
                    }
                    if (!valid) {
                        notAvailable.markVis(ground.immutable());
                    } else {
                        int sdx = 0;
                        while (sdx < 2) {
                            int sdz = 0;
                            while (sdz < 2) {
                                int touchLimit = this.touchLimit() + 1;
                                boolean continuous = true;
                                BlockPos standPos = ground.above(this.verticalOffset()).offset(sdx, 0, sdz);
                                if (standPos.getY() - ground.getY() <= maxUp) {
                                    BlockPos targetPos2;
                                    for (int dy2 = this.verticalOffset(); !(dy2 >= this.verticalDistance() + this.verticalOffset() || (targetPos2 = ground.offset(sdx, dy2, sdz)).distSqr((Vec3i)standPos) > (double)(touchLimit * touchLimit) || hasRestriction && !withinRestriction.apply(standPos).booleanValue()); ++dy2) {
                                        if (this.isFindingBlock(maid, targetPos2, standPos)) {
                                            return new Pair((Object)ground.immutable(), (Object)standPos);
                                        }
                                        if (continuous) {
                                            if (!level.getBlockState(standPos.above().above()).isAir()) {
                                                continuous = false;
                                            } else if (hasRestriction && !withinRestriction.apply(standPos.above().above()).booleanValue()) {
                                                continuous = false;
                                            }
                                        }
                                        if (!continuous) {
                                            --touchLimit;
                                        } else if ((standPos = standPos.above()).getY() - ground.getY() > maxUp) break;
                                        if (touchLimit <= 0) break;
                                    }
                                }
                                sdz = sdz <= 0 ? 1 - sdz : -sdz;
                            }
                            sdx = sdx <= 0 ? 1 - sdx : -sdx;
                        }
                    }
                }
                dz = dz <= 0 ? 1 - dz : -dz;
            }
            dx = dx <= 0 ? 1 - dx : -dx;
        }
        return null;
    }

    default public int countMaxUsableBlockItems(EntityMaid maid) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        int count = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.isValidItemStack(maid, stack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    default public boolean swapValidItemToHand(EntityMaid maid) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.isValidItemStack(maid, stack)) continue;
            inv.setStackInSlot(i, maid.getMainHandItem());
            maid.setItemInHand(InteractionHand.MAIN_HAND, stack);
            return true;
        }
        return false;
    }

    default public boolean swapValidToolToHand(EntityMaid maid) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.isDestroyTool(maid, stack)) continue;
            inv.setStackInSlot(i, maid.getMainHandItem());
            maid.setItemInHand(InteractionHand.MAIN_HAND, stack);
            return true;
        }
        return false;
    }

    public boolean isValidItemStack(EntityMaid var1, ItemStack var2);

    public boolean isDestroyTool(EntityMaid var1, ItemStack var2);

    default public int verticalOffset() {
        return 2;
    }

    default public int verticalDistance() {
        return 15;
    }

    default public int scanRange(EntityMaid maid) {
        return maid.hasRestriction() ? (int)maid.getRestrictRadius() : 15;
    }

    default public int touchLimit() {
        return 7;
    }

    default public boolean tryPlaceBlockUp(EntityMaid maid, BlockPos targetPos) {
        return MaidUtils.placeBlock(maid, targetPos);
    }

    default public boolean tryDestroyBlockUp(EntityMaid maid, BlockPos targetPos) {
        return MaidUtils.destroyBlock(maid, targetPos);
    }
}

