/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.api.ItemLocateEvent;
import studio.fantasyit.maid_useful_task.behavior.common.FindTargetMoveBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.FindTargetWaitBehavior;
import studio.fantasyit.maid_useful_task.compat.CompatEntry;
import studio.fantasyit.maid_useful_task.task.IMaidFindTargetTask;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;

public class MaidLocateTask
implements IMaidTask,
IMaidFindTargetTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"locate");

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return Items.ENDER_EYE.getDefaultInstance();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid entityMaid) {
        return null;
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid entityMaid) {
        ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>> list = new ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        list.add(Pair.of((Object)1, (Object)((Object)new FindTargetMoveBehavior())));
        list.add(Pair.of((Object)2, (Object)((Object)new FindTargetWaitBehavior())));
        return list;
    }

    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    public boolean isEnable(EntityMaid maid) {
        return Config.enableLocateTask;
    }

    @Override
    @Nullable
    public BlockPos findTarget(ServerLevel level, EntityMaid maid) {
        ItemLocateEvent event;
        ItemLocateEvent posted;
        BlockPos target = null;
        ItemStack itemStack = maid.getMainHandItem();
        ItemStack last = MemoryUtil.getLocateItem(maid);
        if (!last.isEmpty() && !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)last, (ItemStack)itemStack)) {
            MemoryUtil.setLocateItem(maid, itemStack);
            MemoryUtil.clearCommonBlockCache(maid);
        }
        if ((posted = (ItemLocateEvent)NeoForge.EVENT_BUS.post((Event)(event = new ItemLocateEvent(itemStack, maid, MemoryUtil.getCommonBlockCache(maid))))).isCanceled()) {
            target = event.getTarget();
        } else if (maid.getMainHandItem().is(Items.ENDER_EYE)) {
            BlockPos blockpos;
            target = MemoryUtil.getCommonBlockCache(maid);
            if (target == null && (blockpos = level.findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, maid.blockPosition(), 100, false)) != null) {
                MemoryUtil.setCommonBlockCache(maid, blockpos);
                target = blockpos;
            }
        } else if (maid.getMainHandItem().is(Items.COMPASS)) {
            LodestoneTracker lodeData;
            GlobalPos globalPos;
            target = MemoryUtil.getCommonBlockCache(maid);
            if (target == null && (globalPos = (lodeData = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER)) != null && lodeData.target().isPresent() ? (GlobalPos)lodeData.target().get() : CompassItem.getSpawnPosition((Level)level)) != null && level.dimension().equals(globalPos.dimension())) {
                MemoryUtil.setCommonBlockCache(maid, globalPos.pos());
                target = globalPos.pos();
            }
        } else if (maid.getMainHandItem().is(ItemTags.BEDS)) {
            LivingEntity owner;
            target = MemoryUtil.getCommonBlockCache(maid);
            if (target == null && (owner = maid.getOwner()) instanceof ServerPlayer) {
                GlobalPos globalRespawn;
                ServerPlayer player = (ServerPlayer)owner;
                if (player.getRespawnDimension().equals(level.dimension()) && (target = player.getRespawnPosition()) == null && (globalRespawn = CompassItem.getSpawnPosition((Level)level)) != null && level.dimension().equals(globalRespawn.dimension())) {
                    target = globalRespawn.pos();
                }
                if (target == null) {
                    MemoryUtil.setCommonBlockCache(maid, target);
                }
            }
        } else if (maid.getMainHandItem().is(Items.FILLED_MAP)) {
            MapItemSavedData savedData;
            target = MemoryUtil.getCommonBlockCache(maid);
            if (target == null && (savedData = MapItem.getSavedData((ItemStack)itemStack, (Level)maid.level())) != null) {
                BlockPos.MutableBlockPos tmpTarget = new BlockPos.MutableBlockPos(savedData.centerX, level.getSeaLevel(), savedData.centerZ);
                savedData.getBanners().stream().findFirst().ifPresent(t -> tmpTarget.set((Vec3i)t.pos().immutable()));
                MapDecorations decoList = (MapDecorations)itemStack.get(DataComponents.MAP_DECORATIONS);
                if (decoList != null) {
                    decoList.decorations().entrySet().stream().filter(t -> ((MapDecorations.Entry)t.getValue()).type() == MapDecorationTypes.RED_X).findFirst().ifPresent(t -> {
                        tmpTarget.setX((int)((MapDecorations.Entry)t.getValue()).x());
                        tmpTarget.setZ((int)((MapDecorations.Entry)t.getValue()).z());
                    });
                }
                target = tmpTarget.immutable();
                MemoryUtil.setCommonBlockCache(maid, target);
            }
        } else {
            target = CompatEntry.getLocateTarget(maid, maid.getMainHandItem());
            if (target != null) {
                MemoryUtil.setCommonBlockCache(maid, target);
                return target;
            }
            MemoryUtil.clearCommonBlockCache(maid);
        }
        return target;
    }

    @Override
    public void clearCache(EntityMaid maid) {
        MemoryUtil.clearCommonBlockCache(maid);
    }
}

