/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.behavior.PlayerReviveBehavior;
import studio.fantasyit.maid_useful_task.compat.PlayerRevive;
import studio.fantasyit.maid_useful_task.menu.MaidReviveConfigGui;

public class MaidRevivePlayerTask
implements IMaidTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"revive_player");

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return Items.ENCHANTED_GOLDEN_APPLE.getDefaultInstance();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid entityMaid) {
        return null;
    }

    public boolean isEnable(EntityMaid maid) {
        return PlayerRevive.isEnable() && Config.enableReviveTask;
    }

    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    public boolean enablePanic(EntityMaid maid) {
        return false;
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid entityMaid) {
        ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>> ret = new ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        ret.add(Pair.of((Object)1, (Object)((Object)new PlayerReviveBehavior())));
        return ret;
    }

    public MenuProvider getTaskConfigGuiProvider(final EntityMaid maid) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new MaidReviveConfigGui.Container(index, playerInventory, maid.getId());
            }
        };
    }
}

