/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_useful_task.Config;
import studio.fantasyit.maid_useful_task.behavior.common.BlockUpDestroyBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.BlockUpPlaceBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.BlockUpScheduleBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.DestoryBlockBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.DestoryBlockMoveBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.MaidSelfRescueBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.PlaceBlockBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.PlaceBlockMoveBehavior;
import studio.fantasyit.maid_useful_task.behavior.common.UpdateValidationMemoryBehavior;
import studio.fantasyit.maid_useful_task.data.MaidLoggingConfig;
import studio.fantasyit.maid_useful_task.memory.BlockValidationMemory;
import studio.fantasyit.maid_useful_task.menu.MaidLoggingConfigGui;
import studio.fantasyit.maid_useful_task.task.IMaidBlockDestroyTask;
import studio.fantasyit.maid_useful_task.task.IMaidBlockPlaceTask;
import studio.fantasyit.maid_useful_task.task.IMaidBlockUpTask;
import studio.fantasyit.maid_useful_task.util.MaidUtils;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;

public class MaidTreeTask
implements IMaidTask,
IMaidBlockPlaceTask,
IMaidBlockDestroyTask,
IMaidBlockUpTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"maid_useful_task", (String)"maid_tree");

    public ResourceLocation getUid() {
        return UID;
    }

    public ItemStack getIcon() {
        return Items.OAK_SAPLING.getDefaultInstance();
    }

    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return true;
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid entityMaid) {
        return null;
    }

    public boolean isEnable(EntityMaid maid) {
        return Config.enableLoggingTask;
    }

    public MenuProvider getTaskConfigGuiProvider(final EntityMaid maid) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                return new MaidLoggingConfigGui.Container(index, playerInventory, maid.getId());
            }
        };
    }

    @Override
    public boolean shouldDestroyBlock(EntityMaid maid, BlockPos pos) {
        if (MemoryUtil.getBlockUpContext(maid).hasTarget() && pos.getY() < maid.getBlockY() && pos.getX() == maid.getBlockX() && pos.getZ() == maid.getBlockZ()) {
            return false;
        }
        BlockState blockState = maid.level().getBlockState(pos);
        if (blockState.is(BlockTags.LOGS)) {
            return !MaidLoggingConfig.get(maid).skipNonNature() || this.isValidNatureTree(maid, pos);
        }
        return false;
    }

    @Override
    public boolean mayDestroy(EntityMaid maid, BlockPos pos) {
        if (MemoryUtil.getBlockUpContext(maid).hasTarget() && pos.getY() < maid.getBlockY() && pos.getX() == maid.getBlockX() && pos.getZ() == maid.getBlockZ()) {
            return false;
        }
        BlockState blockState = maid.level().getBlockState(pos);
        if (blockState.is(BlockTags.LEAVES)) {
            return true;
        }
        return blockState.is(BlockTags.LOGS);
    }

    @Override
    public boolean shouldPlaceItemStack(EntityMaid maid, ItemStack itemStack) {
        if (!((MaidLoggingConfig.Data)maid.getOrCreateData(MaidLoggingConfig.KEY, (Object)MaidLoggingConfig.Data.getDefault())).plant()) {
            return false;
        }
        return itemStack.is(ItemTags.SAPLINGS);
    }

    @Override
    public boolean shouldPlacePos(EntityMaid maid, ItemStack itemStack, BlockPos pos) {
        int[] dv;
        ServerLevel level = (ServerLevel)maid.level();
        if (!level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            return false;
        }
        if (!level.getBlockState(pos).canBeReplaced()) {
            return false;
        }
        for (int dx : dv = new int[]{0, 1, -1, 2, -2}) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz : dv) {
                    if (dx == 0 && dy == 0 && dz == 0 || level.getBlockState(pos.offset(dx, dy, dz)).canBeReplaced()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void tryTakeOutTool(EntityMaid maid) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).is(ItemTags.AXES)) continue;
            @NotNull ItemStack tmp = inv.getStackInSlot(i);
            inv.setStackInSlot(i, maid.getMainHandItem());
            maid.setItemInHand(InteractionHand.MAIN_HAND, tmp);
            return;
        }
    }

    public void swapShearsOrNone(EntityMaid maid) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        int target = -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).is(Items.SHEARS) || inv.getStackInSlot(i).is(ItemTags.HOES)) {
                target = i;
                break;
            }
            if (inv.getStackInSlot(i).isDamageableItem()) continue;
            target = i;
        }
        if (target != -1) {
            @NotNull ItemStack tmp = inv.getStackInSlot(target);
            inv.setStackInSlot(target, maid.getMainHandItem());
            maid.setItemInHand(InteractionHand.MAIN_HAND, tmp);
        }
    }

    @Override
    public void tryTakeOutToolForTarget(EntityMaid maid, BlockPos pos) {
        if (maid.level().getBlockState(pos).is(BlockTags.LEAVES)) {
            this.swapShearsOrNone(maid);
        } else {
            this.tryTakeOutTool(maid);
        }
    }

    @Override
    public boolean availableToGetDrop(EntityMaid maid, WrappedMaidFakePlayer fakePlayer, BlockPos pos, BlockState targetBlockState) {
        if (targetBlockState.is(BlockTags.LEAVES)) {
            return true;
        }
        return IMaidBlockDestroyTask.super.availableToGetDrop(maid, fakePlayer, pos, targetBlockState);
    }

    protected boolean isValidNatureTree(EntityMaid maid, BlockPos startPos) {
        HashSet<BlockPos> vis = new HashSet<BlockPos>();
        BlockValidationMemory validationMemory = MemoryUtil.getBlockValidationMemory(maid);
        boolean validNatureTree = this.isValidNatureTree(maid, startPos, vis, 0, validationMemory);
        for (BlockPos pos : vis) {
            BlockState blockState = maid.level().getBlockState(pos);
            if (!blockState.is(BlockTags.LEAVES) && !blockState.is(BlockTags.LOGS)) continue;
            if (validNatureTree) {
                validationMemory.setValid(pos);
                continue;
            }
            validationMemory.setInvalid(pos);
        }
        return validNatureTree;
    }

    protected boolean isValidNatureTree(EntityMaid maid, BlockPos startPos, Set<BlockPos> visited, int depth, BlockValidationMemory validationMemory) {
        int[] dv;
        if (validationMemory.hasRecord(startPos)) {
            return validationMemory.isValid(startPos, false);
        }
        if (visited.contains(startPos)) {
            return false;
        }
        if (depth > 100) {
            return false;
        }
        visited.add(startPos);
        boolean valid = false;
        for (int dx : dv = new int[]{0, 1, -1}) {
            for (int dz : dv) {
                for (int dy : dv) {
                    BlockPos offset = startPos.offset(dx, dy, dz);
                    BlockState blockState = maid.level().getBlockState(offset);
                    if (blockState.is(BlockTags.LEAVES) && blockState.hasProperty((Property)LeavesBlock.PERSISTENT) && !((Boolean)blockState.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
                        valid = true;
                    }
                    if (!blockState.is(BlockTags.LOGS) || !this.isValidNatureTree(maid, offset, visited, depth + 1, validationMemory)) continue;
                    valid = true;
                }
            }
        }
        if (valid) {
            validationMemory.setValid(startPos);
        } else {
            validationMemory.setInvalid(startPos);
        }
        return valid;
    }

    @Override
    public List<com.mojang.datafixers.util.Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid entityMaid) {
        ArrayList<com.mojang.datafixers.util.Pair<Integer, BehaviorControl<? super EntityMaid>>> list = new ArrayList<com.mojang.datafixers.util.Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        list.add(com.mojang.datafixers.util.Pair.of((Object)0, (Object)((Object)new MaidSelfRescueBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)1, (Object)((Object)new DestoryBlockBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)1, (Object)((Object)new DestoryBlockMoveBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)2, (Object)((Object)new BlockUpScheduleBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)2, (Object)((Object)new BlockUpPlaceBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)2, (Object)((Object)new BlockUpDestroyBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)3, (Object)((Object)new PlaceBlockBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)3, (Object)((Object)new PlaceBlockMoveBehavior())));
        list.add(com.mojang.datafixers.util.Pair.of((Object)4, (Object)((Object)new UpdateValidationMemoryBehavior())));
        return list;
    }

    @Override
    public boolean isValidItemStack(EntityMaid maid, ItemStack stack) {
        return stack.is(ItemTags.LOGS);
    }

    @Override
    public boolean isDestroyTool(EntityMaid maid, ItemStack stack) {
        return stack.is(ItemTags.AXES);
    }

    @Override
    public boolean isFindingBlock(EntityMaid maid, BlockPos target, BlockPos standPos) {
        if (target.distSqr((Vec3i)standPos) > (double)(this.touchLimit() * this.touchLimit())) {
            return false;
        }
        if (maid.level().getBlockState(target).is(BlockTags.LOGS)) {
            return !MaidLoggingConfig.get(maid).skipNonNature() || this.isValidNatureTree(maid, target);
        }
        return false;
    }

    @Override
    public boolean tryDestroyBlockUp(EntityMaid maid, BlockPos targetPos) {
        return this.tryDestroyBlock(maid, targetPos);
    }

    @Override
    public boolean tryPlaceBlock(EntityMaid maid, BlockPos pos) {
        if (IMaidBlockPlaceTask.super.tryPlaceBlock(maid, pos)) {
            MemoryUtil.getBlockValidationMemory(maid).setValid(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryDestroyBlock(EntityMaid maid, BlockPos blockPos) {
        if (MaidUtils.destroyBlock(maid, blockPos)) {
            MemoryUtil.getBlockValidationMemory(maid).remove(blockPos);
            return true;
        }
        return false;
    }

    @Override
    public Pair<BlockPos, BlockPos> findTargetPosBlockUp(EntityMaid maid, BlockPos center, int maxUp) {
        if (maid.isHomeModeEnable() && MaidLoggingConfig.get(maid).blockUp() && !Config.disableLoggingBlockUp) {
            return IMaidBlockUpTask.super.findTargetPosBlockUp(maid, center, maxUp);
        }
        return null;
    }
}

