/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import studio.fantasyit.maid_useful_task.util.MemoryUtil;
import studio.fantasyit.maid_useful_task.util.WrappedMaidFakePlayer;

public class MaidUtils {
    public static void swapToHand(EntityMaid maid, Predicate<ItemStack> isSuitable) {
        RangedWrapper availableBackpackInv = maid.getAvailableBackpackInv();
        for (int i = 0; i < availableBackpackInv.getSlots(); ++i) {
            ItemStack itemStack = availableBackpackInv.getStackInSlot(i);
            if (!isSuitable.test(itemStack)) continue;
            ItemStack tmp = availableBackpackInv.getStackInSlot(i);
            availableBackpackInv.setStackInSlot(i, maid.getMainHandItem());
            maid.setItemInHand(InteractionHand.MAIN_HAND, tmp);
            return;
        }
    }

    public static float getDestroyProgressDelta(EntityMaid maid, BlockPos blockPos) {
        WrappedMaidFakePlayer fakePlayer = WrappedMaidFakePlayer.get(maid);
        BlockState blockState = maid.level().getBlockState(blockPos);
        return blockState.getDestroyProgress((Player)fakePlayer, (BlockGetter)maid.level(), blockPos);
    }

    public static BlockPos getMaidRestrictCenter(EntityMaid maid) {
        if (MemoryUtil.getBlockUpContext(maid).hasTarget()) {
            return MemoryUtil.getBlockUpContext(maid).getTargetPos();
        }
        if (maid.hasRestriction()) {
            return maid.getRestrictCenter();
        }
        return maid.blockPosition();
    }

    public static boolean destroyBlock(EntityMaid maid, BlockPos blockPos) {
        WrappedMaidFakePlayer fakePlayer = WrappedMaidFakePlayer.get(maid);
        maid.getMainHandItem().hurtAndBreak(1, (LivingEntity)fakePlayer, EquipmentSlot.MAINHAND);
        ServerLevel level = (ServerLevel)maid.level();
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        FluidState fluidState = level.getFluidState(blockPos);
        if (!(blockState.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, blockPos, Block.getId((BlockState)blockState));
        }
        BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
        maid.dropResourcesToMaidInv(blockState, (Level)level, blockPos, blockEntity, maid, maid.getMainHandItem());
        boolean setResult = level.setBlock(blockPos, fluidState.createLegacyBlock(), 3);
        if (setResult) {
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)maid, (BlockState)blockState));
        }
        return setResult;
    }

    public static boolean placeBlock(EntityMaid maid, BlockPos pos) {
        InteractionResult interactionResult;
        WrappedMaidFakePlayer fakePlayer = WrappedMaidFakePlayer.get(maid);
        BlockHitResult result = null;
        ClipContext rayTraceContext = new ClipContext(maid.getPosition(0.0f).add(0.0, (double)maid.getEyeHeight(), 0.0), pos.getCenter(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)fakePlayer);
        result = maid.level().clip(rayTraceContext);
        UseOnContext useContext = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, result);
        InteractionResult actionresult = fakePlayer.getMainHandItem().onItemUseFirst(useContext);
        return actionresult == InteractionResult.PASS && (interactionResult = fakePlayer.getMainHandItem().useOn(useContext)).consumesAction();
    }
}

