/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.memory.BlockTargetMemory;
import studio.fantasyit.maid_useful_task.memory.BlockUpContext;
import studio.fantasyit.maid_useful_task.memory.BlockValidationMemory;
import studio.fantasyit.maid_useful_task.memory.CurrentWork;
import studio.fantasyit.maid_useful_task.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_useful_task.vehicle.MaidVehicleControlType;

public class MemoryUtil {
    @Nullable
    public static BlockTargetMemory getDestroyTargetMemory(EntityMaid maid) {
        Optional memory = maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.DESTROY_TARGET.get());
        return memory.orElse(null);
    }

    public static void setDestroyTargetMemory(EntityMaid maid, List<BlockPos> blockPosSet) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.DESTROY_TARGET.get(), (Object)new BlockTargetMemory(blockPosSet));
    }

    public static void clearDestroyTargetMemory(EntityMaid maid) {
        maid.getBrain().eraseMemory((MemoryModuleType)MemoryModuleRegistry.DESTROY_TARGET.get());
    }

    public static void clearTarget(EntityMaid maid) {
        maid.getBrain().eraseMemory((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    @Nullable
    public static BlockPos getTargetPos(EntityMaid maid) {
        Optional memory = maid.getBrain().getMemory((MemoryModuleType)InitEntities.TARGET_POS.get());
        return memory.map(PositionTracker::currentBlockPosition).orElse(null);
    }

    @Nullable
    public static BlockPos getPlaceTarget(EntityMaid maid) {
        Optional memory = maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.PLACE_TARGET.get());
        return memory.orElse(null);
    }

    public static void setPlaceTarget(EntityMaid maid, BlockPos blockPos) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.PLACE_TARGET.get(), (Object)blockPos);
    }

    public static void clearPlaceTarget(EntityMaid maid) {
        maid.getBrain().eraseMemory((MemoryModuleType)MemoryModuleRegistry.PLACE_TARGET.get());
    }

    public static void setLookAt(EntityMaid maid, BlockPos pos) {
        maid.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(pos));
    }

    public static BlockUpContext getBlockUpContext(EntityMaid maid) {
        Brain brain = maid.getBrain();
        if (!brain.hasMemoryValue((MemoryModuleType)MemoryModuleRegistry.BLOCK_UP_TARGET.get())) {
            brain.setMemory((MemoryModuleType)MemoryModuleRegistry.BLOCK_UP_TARGET.get(), (Object)new BlockUpContext());
        }
        return (BlockUpContext)brain.getMemory((MemoryModuleType)MemoryModuleRegistry.BLOCK_UP_TARGET.get()).get();
    }

    public static BlockValidationMemory getBlockValidationMemory(EntityMaid maid) {
        Brain brain = maid.getBrain();
        if (!brain.hasMemoryValue((MemoryModuleType)MemoryModuleRegistry.BLOCK_VALIDATION.get())) {
            brain.setMemory((MemoryModuleType)MemoryModuleRegistry.BLOCK_VALIDATION.get(), (Object)new BlockValidationMemory());
        }
        return (BlockValidationMemory)brain.getMemory((MemoryModuleType)MemoryModuleRegistry.BLOCK_VALIDATION.get()).get();
    }

    public static void setTarget(EntityMaid maid, BlockPos targetPos, float speed) {
        maid.getBrain().setMemory((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(targetPos));
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)targetPos, (float)speed, (int)0);
    }

    public static CurrentWork getCurrent(EntityMaid maid) {
        return maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.CURRENT_WORK.get()).orElse(CurrentWork.IDLE);
    }

    public static void setCurrent(EntityMaid maid, CurrentWork currentWork) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.CURRENT_WORK.get(), (Object)currentWork);
    }

    public static void setCommonBlockCache(EntityMaid maid, BlockPos pos) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.COMMON_BLOCK_CACHE.get(), (Object)pos);
    }

    public static BlockPos getCommonBlockCache(EntityMaid maid) {
        return maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.COMMON_BLOCK_CACHE.get()).orElse(null);
    }

    public static void setAllowHandleVehicle(EntityMaid maid, MaidVehicleControlType allow) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.IS_ALLOW_HANDLE_VEHICLE.get(), (Object)allow);
    }

    public static MaidVehicleControlType getAllowHandleVehicle(EntityMaid maid) {
        return maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.IS_ALLOW_HANDLE_VEHICLE.get()).orElse(MaidVehicleControlType.NONE);
    }

    public static void clearCommonBlockCache(EntityMaid maid) {
        maid.getBrain().eraseMemory((MemoryModuleType)MemoryModuleRegistry.COMMON_BLOCK_CACHE.get());
    }

    public static void setLocateItem(EntityMaid maid, ItemStack item) {
        maid.getBrain().setMemory((MemoryModuleType)MemoryModuleRegistry.LOCATE_ITEM.get(), (Object)item);
    }

    public static ItemStack getLocateItem(EntityMaid maid) {
        return maid.getBrain().getMemory((MemoryModuleType)MemoryModuleRegistry.LOCATE_ITEM.get()).orElse(ItemStack.EMPTY);
    }
}

