/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedMaidFakePlayer
extends FakePlayer {
    private static ConcurrentHashMap<UUID, WrappedMaidFakePlayer> cache = new ConcurrentHashMap();
    private final EntityMaid maid;

    public static WrappedMaidFakePlayer get(EntityMaid maid) {
        if (cache.containsKey(maid.getUUID())) {
            WrappedMaidFakePlayer wrappedMaidFakePlayer = cache.get(maid.getUUID());
            if (!wrappedMaidFakePlayer.maid.isAlive()) {
                cache.remove(maid.getUUID());
            } else {
                return wrappedMaidFakePlayer;
            }
        }
        WrappedMaidFakePlayer fakePlayer = new WrappedMaidFakePlayer(maid);
        cache.put(maid.getUUID(), fakePlayer);
        return fakePlayer;
    }

    private WrappedMaidFakePlayer(EntityMaid maid) {
        super((ServerLevel)maid.level(), new GameProfile(UUID.randomUUID(), maid.getName().getString()));
        this.maid = maid;
        this.inventory = new WrappedMaidInventory(maid, this);
    }

    public boolean removeEffect(Holder<MobEffect> p_21196_) {
        if (this.maid == null) {
            return false;
        }
        return this.maid.removeEffect(p_21196_);
    }

    @Nullable
    public MobEffectInstance removeEffectNoUpdate(@Nullable Holder<MobEffect> p_21164_) {
        if (this.maid == null) {
            return super.removeEffectNoUpdate(p_21164_);
        }
        return this.maid.removeEffectNoUpdate(p_21164_);
    }

    public boolean removeAllEffects() {
        if (this.maid == null) {
            return false;
        }
        return this.maid.removeAllEffects();
    }

    public boolean addEffect(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        if (this.maid == null) {
            return super.addEffect(p_147208_, p_147209_);
        }
        return this.maid.addEffect(p_147208_, p_147209_);
    }

    public boolean canBeAffected(MobEffectInstance p_21197_) {
        if (this.maid == null) {
            return super.canBeAffected(p_21197_);
        }
        return this.maid.canBeAffected(p_21197_);
    }

    public void forceAddEffect(MobEffectInstance p_147216_, @Nullable Entity p_147217_) {
        this.maid.forceAddEffect(p_147216_, p_147217_);
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> p_21125_) {
        if (this.maid == null) {
            return super.getEffect(p_21125_);
        }
        return this.maid.getEffect(p_21125_);
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        if (this.maid == null) {
            return super.getActiveEffects();
        }
        return this.maid.getActiveEffects();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        if (this.maid == null) {
            return super.getActiveEffectsMap();
        }
        return this.maid.getActiveEffectsMap();
    }

    public boolean hasEffect(Holder<MobEffect> p_21024_) {
        if (this.maid == null) {
            return super.hasEffect(p_21024_);
        }
        return this.maid.hasEffect(p_21024_);
    }

    public ItemStack getMainHandItem() {
        if (this.maid == null) {
            return ItemStack.EMPTY;
        }
        return this.maid.getMainHandItem();
    }

    public ItemStack getItemInHand(InteractionHand p_21121_) {
        if (this.maid == null) {
            return super.getItemInHand(p_21121_);
        }
        return this.maid.getItemInHand(p_21121_);
    }

    public void setItemInHand(InteractionHand p_21009_, ItemStack p_21010_) {
        if (this.maid == null) {
            return;
        }
        this.maid.setItemInHand(p_21009_, p_21010_);
    }

    public void setItemSlot(EquipmentSlot p_36161_, ItemStack p_36162_) {
        if (this.maid == null) {
            return;
        }
        this.maid.setItemSlot(p_36161_, p_36162_);
    }

    public ItemStack getItemBySlot(EquipmentSlot p_36257_) {
        if (this.maid == null) {
            return ItemStack.EMPTY;
        }
        return this.maid.getItemBySlot(p_36257_);
    }

    public boolean isEyeInFluid(TagKey<Fluid> p_204030_) {
        if (this.maid == null) {
            return false;
        }
        return this.maid.isEyeInFluid(p_204030_);
    }

    public boolean onGround() {
        if (this.maid == null) {
            return false;
        }
        return this.maid.onGround();
    }

    public Level level() {
        if (this.maid == null) {
            return super.level();
        }
        return this.maid.level();
    }

    public ServerLevel serverLevel() {
        if (this.maid == null) {
            return super.serverLevel();
        }
        return (ServerLevel)this.maid.level();
    }

    public BlockPos blockPosition() {
        if (this.maid == null) {
            return BlockPos.ZERO;
        }
        return this.maid.blockPosition();
    }

    public Vec3 position() {
        if (this.maid == null) {
            return Vec3.ZERO;
        }
        return this.maid.position();
    }

    public float distanceTo(Entity p_20271_) {
        if (this.maid == null) {
            return super.distanceTo(p_20271_);
        }
        return this.maid.distanceTo(p_20271_);
    }

    public double distanceToSqr(double p_20276_, double p_20277_, double p_20278_) {
        if (this.maid == null) {
            return super.distanceToSqr(p_20276_, p_20277_, p_20278_);
        }
        return this.maid.distanceToSqr(p_20276_, p_20277_, p_20278_);
    }

    public double distanceToSqr(Vec3 p_20239_) {
        if (this.maid == null) {
            return super.distanceToSqr(p_20239_);
        }
        return this.maid.distanceToSqr(p_20239_);
    }

    public void teleportTo(double p_8969_, double p_8970_, double p_8971_) {
        if (this.maid == null) {
            return;
        }
        this.maid.teleportTo(p_8969_, p_8970_, p_8971_);
    }

    public boolean teleportTo(ServerLevel p_265564_, double p_265424_, double p_265680_, double p_265312_, Set<RelativeMovement> p_265192_, float p_265059_, float p_265266_) {
        if (this.maid == null) {
            return false;
        }
        return this.maid.teleportTo(p_265564_, p_265424_, p_265680_, p_265312_, p_265192_, p_265059_, p_265266_);
    }

    public void teleportRelative(double p_251611_, double p_248861_, double p_252266_) {
        if (this.maid == null) {
            return;
        }
        this.maid.teleportRelative(p_251611_, p_248861_, p_252266_);
    }

    public void moveTo(double p_9171_, double p_9172_, double p_9173_) {
        if (this.maid == null) {
            return;
        }
        this.maid.moveTo(p_9171_, p_9172_, p_9173_);
    }

    public ChunkPos chunkPosition() {
        if (this.maid == null) {
            return new ChunkPos(0, 0);
        }
        return this.maid.chunkPosition();
    }

    public static class WrappedMaidInventory
    extends Inventory {
        private final EntityMaid maid;

        public WrappedMaidInventory(EntityMaid p_35983_, WrappedMaidFakePlayer fakePlayer) {
            super((Player)fakePlayer);
            this.maid = p_35983_;
        }

        @NotNull
        public ItemStack getSelected() {
            return this.maid.getMainHandItem();
        }

        public float getDestroySpeed(BlockState p_36021_) {
            return this.maid.getMainHandItem().getDestroySpeed(p_36021_);
        }
    }
}

