/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.vehicle;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import studio.fantasyit.maid_useful_task.network.MaidSyncVehiclePacket;
import studio.fantasyit.maid_useful_task.vehicle.AbstractMaidControllableVehicle;
import studio.fantasyit.maid_useful_task.vehicle.broom.VehicleBroom;

public class MaidVehicleManager {
    public static List<AbstractMaidControllableVehicle> controllableVehicles = new ArrayList<AbstractMaidControllableVehicle>();

    public static void register() {
        controllableVehicles.add(new VehicleBroom());
    }

    public static void addControllableVehicle(AbstractMaidControllableVehicle vehicle) {
        controllableVehicles.add(vehicle);
    }

    public static Optional<AbstractMaidControllableVehicle> getControllableVehicle(EntityMaid maid) {
        for (AbstractMaidControllableVehicle vehicle : controllableVehicles) {
            if (!vehicle.isMaidOnThisVehicle(maid)) continue;
            return Optional.of(vehicle);
        }
        return Optional.empty();
    }

    public static void syncVehicleParameter(EntityMaid maid) {
        MaidVehicleManager.getControllableVehicle(maid).ifPresent(vehicle -> {
            CompoundTag syncVehicleParameter = vehicle.getSyncVehicleParameter(maid);
            if (syncVehicleParameter != null) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)maid, (CustomPacketPayload)new MaidSyncVehiclePacket(maid.getId(), syncVehicleParameter), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public static void stopControlling(EntityMaid maid) {
        MaidVehicleManager.getControllableVehicle(maid).ifPresent(vehicle -> vehicle.maidStopControlVehicle(maid));
    }
}

