/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.vehicle.broom;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import studio.fantasyit.maid_useful_task.vehicle.MaidVehicleControlType;

public class BroomControlParamStore {
    private static final BroomControlParam NONE = new BroomControlParam(0.0f, 0.0f, 0.0f, 0.0f, MaidVehicleControlType.NONE);
    private static final Map<UUID, BroomControlParam> store = new HashMap<UUID, BroomControlParam>();

    public static void setControlParam(EntityMaid maid, BroomControlParam param) {
        store.put(maid.getUUID(), param);
    }

    public static BroomControlParam getControlParam(EntityMaid maid) {
        if (!store.containsKey(maid.getUUID())) {
            return NONE;
        }
        return store.get(maid.getUUID());
    }

    public static void removeControlParam(EntityMaid maid) {
        store.remove(maid.getUUID());
    }

    public record BroomControlParam(float xRot, float yRot, float vertical, float forward, MaidVehicleControlType type) {
        public static BroomControlParam fromNbt(CompoundTag tag) {
            return new BroomControlParam(tag.getFloat("xRot"), tag.getFloat("yRot"), tag.getFloat("vertical"), tag.getFloat("forward"), MaidVehicleControlType.valueOf(tag.getString("type")));
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("xRot", this.xRot);
            tag.putFloat("yRot", this.yRot);
            tag.putFloat("vertical", this.vertical);
            tag.putFloat("forward", this.forward);
            tag.putString("type", this.type.name());
            return tag;
        }
    }
}

