/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.vehicle.broom;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IBroomControl;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import studio.fantasyit.maid_useful_task.vehicle.MaidVehicleControlType;
import studio.fantasyit.maid_useful_task.vehicle.broom.BroomControlParamStore;

public class BroomController
implements IBroomControl {
    private final EntityBroom broom;

    public BroomController(EntityBroom broom) {
        this.broom = broom;
    }

    public int getPriority() {
        return 10;
    }

    public boolean inControl(Player player, EntityMaid entityMaid) {
        return BroomControlParamStore.getControlParam(entityMaid).type() != MaidVehicleControlType.NONE;
    }

    public void travel(Player player, EntityMaid entityMaid) {
        BroomControlParamStore.BroomControlParam param = BroomControlParamStore.getControlParam(entityMaid);
        float forward = 0.0f;
        float strafe = 0.0f;
        float vertical = param.vertical();
        if (param.type() == MaidVehicleControlType.FULL) {
            forward = param.forward() / 15.0f;
        } else {
            boolean keyRight;
            boolean keyForward = player.zza > 0.0f;
            boolean keyBack = player.zza < 0.0f;
            boolean keyLeft = player.xxa > 0.0f;
            boolean bl = keyRight = player.xxa < 0.0f;
            if (keyForward || keyBack || keyLeft || keyRight) {
                float f = keyLeft ? 0.2f : (strafe = keyRight ? -0.2f : 0.0f);
                forward = keyForward ? 0.375f : (keyBack ? -0.2f : 0.0f);
            } else {
                vertical = 0.0f;
            }
        }
        double playerSpeed = player.getAttributeValue(Attributes.MOVEMENT_SPEED);
        double speed = Math.max(playerSpeed - 0.1, 0.0) * 2.5 + 0.1;
        Vec3 targetMotion = new Vec3((double)strafe, (double)vertical, (double)forward).scale(speed * 20.0);
        targetMotion = targetMotion.yRot((float)((double)(-this.broom.getYRot()) * Math.PI / 180.0));
        Vec3 currentMotion = this.broom.getDeltaMovement();
        Vec3 newMotion = currentMotion.lerp(targetMotion, 0.25);
        this.broom.setDeltaMovement(newMotion);
    }

    public void tickRot(Player player, EntityMaid entityMaid) {
        BroomControlParamStore.BroomControlParam param = BroomControlParamStore.getControlParam(entityMaid);
        this.broom.yBodyRot = this.broom.yHeadRot = this.broom.getYRot();
        this.broom.yRotO = this.broom.yHeadRot;
        this.broom.setRot(param.yRot(), param.xRot());
    }
}

