/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_useful_task.vehicle.broom;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_useful_task.util.RotUtil;
import studio.fantasyit.maid_useful_task.vehicle.AbstractMaidControllableVehicle;
import studio.fantasyit.maid_useful_task.vehicle.MaidVehicleControlType;
import studio.fantasyit.maid_useful_task.vehicle.broom.BroomControlParamStore;

public class VehicleBroom
extends AbstractMaidControllableVehicle {
    @Override
    public boolean isMaidOnThisVehicle(EntityMaid maid) {
        return maid.getVehicle() instanceof EntityBroom;
    }

    @Override
    public void maidControlVehicle(EntityMaid maid, MaidVehicleControlType type, BlockPos target) {
        if (maid.level().isClientSide) {
            return;
        }
        Entity entity = maid.getVehicle();
        if (entity instanceof EntityBroom) {
            double finalForward;
            EntityBroom vehicle = (EntityBroom)entity;
            if (type == MaidVehicleControlType.NONE) {
                BroomControlParamStore.removeControlParam(maid);
                return;
            }
            double xzDistance = maid.distanceToSqr((double)target.getX(), maid.getY(), (double)target.getZ());
            double finalXRot = vehicle.getXRot();
            double finalYRot = vehicle.getYRot();
            double finalVertical = 0.0;
            if (vehicle.isInWater()) {
                finalXRot = 0.0;
                finalVertical = 0.1;
            } else if (xzDistance < Math.pow(maid.getY() - (double)maid.level().getSeaLevel(), 2.0)) {
                finalXRot = 0.0;
                if (maid.getY() - (double)maid.level().getSeaLevel() < 50.0 || vehicle.onGround()) {
                    finalXRot = 5.0;
                    finalVertical = -0.2;
                } else {
                    finalXRot = 50.0;
                    finalVertical = -0.35;
                }
            } else if (maid.getY() < 100.0) {
                finalXRot = -50.0;
                finalVertical = 0.2;
            } else if (maid.getY() > 160.0) {
                finalXRot = 0.0;
                finalVertical = -0.1;
            } else {
                finalXRot = 0.0;
                finalVertical = 0.05;
            }
            finalYRot = RotUtil.getYRot(maid.position(), target.getCenter());
            double d = finalForward = type == MaidVehicleControlType.FULL ? 3.0 : 0.0;
            if (xzDistance < 25.0) {
                finalForward = 0.0;
            }
            BroomControlParamStore.setControlParam(maid, new BroomControlParamStore.BroomControlParam((float)finalXRot, (float)finalYRot, (float)finalVertical, (float)finalForward, type));
        }
    }

    @Override
    public void maidStopControlVehicle(EntityMaid maid) {
        BroomControlParamStore.removeControlParam(maid);
    }

    @Override
    public void syncVehicleParameter(EntityMaid maid, CompoundTag tag) {
        BroomControlParamStore.BroomControlParam broomControlParam = BroomControlParamStore.BroomControlParam.fromNbt(tag);
        BroomControlParamStore.setControlParam(maid, broomControlParam);
    }

    @Override
    @Nullable
    public CompoundTag getSyncVehicleParameter(EntityMaid maid) {
        return BroomControlParamStore.getControlParam(maid).toNbt();
    }
}

