/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AECreativeTabIds;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import com.mojang.serialization.Codec;
import io.github.projectet.ae2things.command.Command;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.util.StorageManager;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@Mod(value="ae2things")
public class AE2Things {
    public static final String MOD_ID = "ae2things";
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ae2things");
    public static final DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((String)"ae2things");
    public static final DataComponentType<UUID> DATA_DISK_ID = AE2Things.registerDataComponentType("disk_id", builder -> builder.persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC));
    public static final DataComponentType<Long> DATA_DISK_ITEM_COUNT = AE2Things.registerDataComponentType("disk_item_count", builder -> builder.persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG));
    public static final DataComponentType<FuzzyMode> DATA_FUZZY_MODE = AE2Things.registerDataComponentType("fuzzy_mode", builder -> builder.persistent(FuzzyMode.CODEC).networkSynchronized(FuzzyMode.STREAM_CODEC));
    @Nullable
    private static StorageManager storageManager;
    @Nullable
    private static MinecraftServer storageManagerServer;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public AE2Things(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        COMPONENTS.register(modEventBus);
        AETItems.init();
        modEventBus.addListener(AE2Things::commonSetup);
        modEventBus.addListener(AE2Things::addContentsToCreativeTab);
        NeoForge.EVENT_BUS.addListener(Command::commandRegister);
        NeoForge.EVENT_BUS.addListener(AE2Things::onServerStarted);
        NeoForge.EVENT_BUS.addListener(AE2Things::onServerStopped);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        AETItems.commonSetup();
        StorageCells.addCellHandler((ICellHandler)DISKCellHandler.INSTANCE);
        event.enqueueWork(() -> {
            String disksText = "text.ae2things.disk_drives";
            for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
                Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
            }
        });
    }

    public static void addContentsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (!event.getTabKey().equals(AECreativeTabIds.MAIN)) {
            return;
        }
        event.accept(AETItems.DISK_HOUSING);
        for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
            event.accept((ItemLike)cell.get());
        }
    }

    private static void onServerStarted(ServerStartedEvent event) {
        storageManagerServer = event.getServer();
        storageManager = StorageManager.getInstance(event.getServer());
    }

    private static void onServerStopped(ServerStoppedEvent event) {
        if (storageManagerServer == event.getServer()) {
            storageManagerServer = null;
            storageManager = null;
        }
    }

    private static <T> DataComponentType<T> registerDataComponentType(String name, Consumer<DataComponentType.Builder<T>> customizer) {
        DataComponentType.Builder builder = DataComponentType.builder();
        customizer.accept(builder);
        DataComponentType componentType = builder.build();
        COMPONENTS.register(name, () -> componentType);
        return componentType;
    }

    @Nullable
    public static StorageManager currentStorageManager() {
        return storageManager;
    }
}

