/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.ae2addonlib.util.Colors;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class QuantumArmorRenderer
extends GeoArmorRenderer<QuantumArmorBase> {
    public static final String HUD_BONE = "hud";
    public static final String LEFT_BLADE_BONE = "blade_left";
    public static final String RIGHT_BLADE_BONE = "blade_right";
    public static final String FACE_SHIELD_BONE = "face_shield";
    private final Map<EquipmentSlot, Boolean> visibilityMap = new HashMap<EquipmentSlot, Boolean>();
    private final QuantumArmorTintLayer tintLayer;

    public QuantumArmorRenderer() {
        super((GeoModel)new DefaultedItemGeoModel(AdvancedAE.makeId("quantum_armor")));
        this.visibilityMap.put(EquipmentSlot.HEAD, true);
        this.visibilityMap.put(EquipmentSlot.CHEST, true);
        this.visibilityMap.put(EquipmentSlot.LEGS, true);
        this.visibilityMap.put(EquipmentSlot.FEET, true);
        this.tintLayer = new QuantumArmorTintLayer(this);
        this.addRenderLayer((GeoRenderLayer)this.tintLayer);
    }

    public void setBoneVisible(String boneName, boolean visible) {
        this.getGeoModel().getBone(boneName).ifPresent(geoBone -> geoBone.setHidden(!visible));
    }

    public void setVisible(EquipmentSlot slot, boolean visible) {
        this.visibilityMap.put(slot, visible);
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.setVisibleBySlot(currentSlot);
        super.applyBoneVisibilityBySlot(currentSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setVisibleBySlot(EquipmentSlot slot) {
        QuantumArmorRenderer model = this;
        boolean visible = this.visibilityMap.get(slot);
        switch (slot) {
            case HEAD: {
                ((HumanoidModel)model).head.visible = visible;
                break;
            }
            case CHEST: {
                ((HumanoidModel)model).body.visible = visible;
                ((HumanoidModel)model).rightArm.visible = visible;
                ((HumanoidModel)model).leftArm.visible = visible;
                break;
            }
            case LEGS: 
            case FEET: {
                ((HumanoidModel)model).rightLeg.visible = visible;
                ((HumanoidModel)model).leftLeg.visible = visible;
            }
        }
    }

    public void setTintColor(int color) {
        this.tintLayer.tintColor = color;
    }

    private static class QuantumArmorTintLayer
    extends AutoGlowingGeoLayer<QuantumArmorBase> {
        private final ResourceLocation TINT_TEXTURE = AdvancedAE.makeId("textures/item/quantum_armor_tint.png");
        private int tintColor = Colors.PURPLE.argb();

        public QuantumArmorTintLayer(GeoArmorRenderer<QuantumArmorBase> armorRenderer) {
            super(armorRenderer);
        }

        public void render(PoseStack poseStack, QuantumArmorBase animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType render = RenderType.entityCutout((ResourceLocation)this.TINT_TEXTURE);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, render, bufferSource.getBuffer(render), partialTick, packedLight, packedOverlay, this.tintColor);
            renderType = this.getRenderType((GeoAnimatable)animatable, bufferSource);
            if (renderType != null) {
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, this.tintColor);
            }
        }

        protected ResourceLocation getTextureResource(QuantumArmorBase animatable) {
            return this.TINT_TEXTURE;
        }
    }
}

