/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.widgets;

import appeng.api.stacks.GenericStack;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public record UpgradeState(UpgradeType type, boolean enabled, int currentValue, boolean extra, List<GenericStack> filter) {
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeState> STREAM_CODEC = StreamCodec.ofMember(UpgradeState::write, UpgradeState::decode);

    public UpgradeState(UpgradeType type, boolean enabled, int currentValue, boolean extra) {
        this(type, enabled, currentValue, extra, List.of());
    }

    public static UpgradeState decode(RegistryFriendlyByteBuf stream) {
        UpgradeType type = (UpgradeType)stream.readEnum(UpgradeType.class);
        boolean enabled = stream.readBoolean();
        int currentValue = stream.readInt();
        boolean extra = stream.readBoolean();
        if (stream.readBoolean()) {
            List filter = (List)GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)stream);
            return new UpgradeState(type, enabled, currentValue, extra, filter);
        }
        return new UpgradeState(type, enabled, currentValue, extra);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeEnum((Enum)this.type);
        data.writeBoolean(this.enabled);
        data.writeInt(this.currentValue);
        data.writeBoolean(this.extra);
        if (this.filter != null) {
            data.writeBoolean(true);
            GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)data, this.filter);
        } else {
            data.writeBoolean(false);
        }
    }
}

