/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ITerminalHost;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsEncoder;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternEncodingTermMenu.class})
public class MixinPatternEncodingTermMenu
extends MEStorageMenu {
    @Final
    @Shadow(remap=false)
    private RestrictedInputSlot encodedPatternSlot;

    @Inject(method={"encodeProcessingPattern"}, at={@At(value="RETURN", ordinal=2)}, cancellable=true, remap=false)
    private void onEncodeProcessingPattern(CallbackInfoReturnable<ItemStack> cir, @Local(ordinal=0) GenericStack[] in, @Local(ordinal=1) GenericStack[] out) {
        if (this.encodedPatternSlot.hasItem()) {
            ItemStack encodedPattern = this.encodedPatternSlot.getItem();
            IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)encodedPattern, (Level)this.getPlayerInventory().player.level());
            if (details == null) {
                return;
            }
            if (details instanceof AdvProcessingPattern) {
                AdvProcessingPattern pattern = (AdvProcessingPattern)details;
                HashMap dirMap = pattern.getDirectionMap();
                HashMap<AEKey, Direction> newDirMap = new HashMap<AEKey, Direction>();
                for (GenericStack input : in) {
                    if (input == null || !dirMap.containsKey(input.what())) continue;
                    newDirMap.put(input.what(), (Direction)((LinkedHashMap)dirMap).get(input.what()));
                }
                if (!newDirMap.isEmpty()) {
                    cir.setReturnValue((Object)AdvPatternDetailsEncoder.encodeProcessingPattern(Arrays.asList(in), Arrays.asList(out), newDirMap));
                }
            }
        }
    }

    public MixinPatternEncodingTermMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host) {
        super(menuType, id, ip, host);
    }
}

