/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.helpers.patternprovider.PatternProviderLogic;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogicHost;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public class MixinPatternProviderLogic {
    @Final
    @Shadow
    IManagedGridNode mainNode;

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"getActiveSides"}, at={@At(value="TAIL")}, cancellable=true)
    private void onGetActiveSides(CallbackInfoReturnable<EnumSet<Direction>> cir, @Local EnumSet<Direction> sides) {
        IGridNode node = this.mainNode.getNode();
        if (node != null) {
            for (Map.Entry entry : node.getInWorldConnections().entrySet()) {
                IGridNode otherNode = ((IGridConnection)entry.getValue()).getOtherSide(node);
                if (!(otherNode.getOwner() instanceof AdvPatternProviderLogicHost)) continue;
                sides.remove(entry.getKey());
            }
        }
        cir.setReturnValue(sides);
    }
}

