/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterTermScreen;

public record QuantumCrafterTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantumCrafterTerminalPacket> STREAM_CODEC = StreamCodec.ofMember(QuantumCrafterTerminalPacket::write, QuantumCrafterTerminalPacket::decode);
    private static final StreamCodec<RegistryFriendlyByteBuf, Int2ObjectMap<ItemStack>> SLOTS_STREAM_CODEC = ByteBufCodecs.map(Int2ObjectOpenHashMap::new, (StreamCodec)ByteBufCodecs.SHORT.map(Short::intValue, Integer::shortValue), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, (int)128);
    private static final StreamCodec<RegistryFriendlyByteBuf, Int2BooleanMap> BOOLEAN_STREAM_CODEC = ByteBufCodecs.map(Int2BooleanOpenHashMap::new, (StreamCodec)ByteBufCodecs.SHORT.map(Short::intValue, Integer::shortValue), (StreamCodec)ByteBufCodecs.BOOL, (int)128);
    public static final CustomPacketPayload.Type<QuantumCrafterTerminalPacket> TYPE = CustomAppEngPayload.createType((String)"quantum_crafter_terminal");

    public CustomPacketPayload.Type<QuantumCrafterTerminalPacket> type() {
        return TYPE;
    }

    public static QuantumCrafterTerminalPacket decode(RegistryFriendlyByteBuf stream) {
        long inventoryId = stream.readVarLong();
        boolean fullUpdate = stream.readBoolean();
        int inventorySize = 0;
        long sortBy = 0L;
        if (fullUpdate) {
            inventorySize = stream.readVarInt();
            sortBy = stream.readVarLong();
        }
        Int2ObjectMap slots = (Int2ObjectMap)SLOTS_STREAM_CODEC.decode((Object)stream);
        Int2BooleanMap enabledArray = (Int2BooleanMap)BOOLEAN_STREAM_CODEC.decode((Object)stream);
        Int2BooleanMap invalidArray = (Int2BooleanMap)BOOLEAN_STREAM_CODEC.decode((Object)stream);
        return new QuantumCrafterTerminalPacket(fullUpdate, inventoryId, inventorySize, sortBy, (Int2ObjectMap<ItemStack>)slots, enabledArray, invalidArray);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeVarLong(this.inventoryId);
        data.writeBoolean(this.fullUpdate);
        if (this.fullUpdate) {
            data.writeVarInt(this.inventorySize);
            data.writeVarLong(this.sortBy);
        }
        SLOTS_STREAM_CODEC.encode((Object)data, this.slots);
        BOOLEAN_STREAM_CODEC.encode((Object)data, (Object)this.enabledArray);
        BOOLEAN_STREAM_CODEC.encode((Object)data, (Object)this.invalidArray);
    }

    public static QuantumCrafterTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, Int2ObjectMap<ItemStack> slots, Int2BooleanArrayMap enabledArray, Int2BooleanArrayMap invalidArray) {
        return new QuantumCrafterTerminalPacket(true, inventoryId, inventorySize, sortBy, slots, (Int2BooleanMap)enabledArray, (Int2BooleanMap)invalidArray);
    }

    public static QuantumCrafterTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots, Int2BooleanArrayMap enabledArray, Int2BooleanArrayMap invalidArray) {
        return new QuantumCrafterTerminalPacket(false, inventoryId, 0, 0L, slots, (Int2BooleanMap)enabledArray, (Int2BooleanMap)invalidArray);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof QuantumCrafterTermScreen) {
            QuantumCrafterTermScreen screen2 = (QuantumCrafterTermScreen)screen;
            if (this.fullUpdate) {
                screen2.postFullUpdate(this.inventoryId, this.sortBy, this.inventorySize, this.slots, this.enabledArray, this.invalidArray);
            } else {
                screen2.postIncrementalUpdate(this.inventoryId, this.slots, this.enabledArray, this.invalidArray);
            }
        }
    }
}

