/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.compatibility.emi.EmiTradeLoot;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CompletableFuture<Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>> futureData = new CompletableFuture();

    public void register(EmiRegistry emiRegistry) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener((lootData, tradeData) -> this.futureData.complete((Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>)Pair.of((Object)lootData, (Object)tradeData)));
        this.futureData.thenAccept(pair -> this.registerData(emiRegistry, (Map)pair.getLeft(), (Map)pair.getRight()));
    }

    private void registerData(EmiRegistry registry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.getInstance().level;
        LOGGER.info("Adding loot information to EMI");
        if (level != null) {
            Map<LootCategory, EmiRecipeCategory> blockCategoryMap = LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> entityCategoryMap = LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> gameplayCategoryMap = LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> tradeCategoryMap = LootCategories.TRADE_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((ResourceLocation)r.getKey(), (EmiRenderable)EmiStack.of((ItemStack)((LootCategory)r.getValue()).getIcon()))));
            blockCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            tradeCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            EmiRecipeCategory blockCategory = EmiCompatibility.createCategory(LootCategories.BLOCK_LOOT);
            EmiRecipeCategory plantCategory = EmiCompatibility.createCategory(LootCategories.PLANT_LOOT);
            EmiRecipeCategory entityCategory = EmiCompatibility.createCategory(LootCategories.ENTITY_LOOT);
            EmiRecipeCategory gameplayCategory = EmiCompatibility.createCategory(LootCategories.GAMEPLAY_LOOT);
            EmiRecipeCategory tradeCategory = EmiCompatibility.createCategory(LootCategories.TRADE_LOOT);
            registry.addCategory(blockCategory);
            registry.addCategory(plantCategory);
            registry.addCategory(entityCategory);
            registry.addCategory(gameplayCategory);
            registry.addCategory(tradeCategory);
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                EmiRecipeCategory category = null;
                if (LootCategories.PLANT_LOOT.validate((Block)block)) {
                    category = plantCategory;
                } else {
                    for (Map.Entry entry : blockCategoryMap.entrySet()) {
                        if (!((LootCategory)entry.getKey()).validate(block)) continue;
                        category = (EmiRecipeCategory)entry.getValue();
                    }
                    if (category == null) {
                        category = blockCategory;
                    }
                }
                registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("/" + location.getPath())), (Block)block, (IDataNode)node, (List<ItemStack>)outputs));
            }, (node, location, entity, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : entityCategoryMap.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                    category = (EmiRecipeCategory)entry.getValue();
                }
                if (category == null) {
                    category = entityCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("/" + location.getPath())), (Entity)entity, (IDataNode)node, (List<ItemStack>)outputs));
            }, (node, location, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry gameplayEntry : gameplayCategoryMap.entrySet()) {
                    if (!((LootCategory)gameplayEntry.getKey()).validate(location.getPath())) continue;
                    category = (EmiRecipeCategory)gameplayEntry.getValue();
                }
                if (category == null) {
                    category = gameplayCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("/" + location.getPath())), (IDataNode)node, (List<ItemStack>)outputs));
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry e : tradeCategoryMap.entrySet()) {
                    if (!((LootCategory)e.getKey()).validate(location.getPath())) continue;
                    category = (EmiRecipeCategory)e.getValue();
                }
                if (category == null) {
                    category = tradeCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("/" + location.getPath())), location.getPath(), (IDataNode)tradeEntry, (List<ItemStack>)inputs, (List<ItemStack>)outputs));
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry e : tradeCategoryMap.entrySet()) {
                    if (!((LootCategory)e.getKey()).validate(location.getPath())) continue;
                    category = (EmiRecipeCategory)e.getValue();
                }
                if (category == null) {
                    category = tradeCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("/" + location.getPath())), location.getPath(), (IDataNode)tradeEntry, (List<ItemStack>)inputs, (List<ItemStack>)outputs));
            });
        } else {
            LOGGER.warn("EMI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static EmiRecipeCategory createCategory(LootCategory<?> category) {
        return new EmiRecipeCategory(Utils.modLoc(category.getKey()), (EmiRenderable)EmiStack.of((ItemStack)category.getIcon()));
    }
}

