/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.jei.JeiBlockLoot;
import com.yanny.ali.compatibility.jei.JeiEntityLoot;
import com.yanny.ali.compatibility.jei.JeiGameplayLoot;
import com.yanny.ali.compatibility.jei.JeiTradeLoot;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<JeiBlockLoot> blockCategoryList = new LinkedList<JeiBlockLoot>();
    private final List<JeiEntityLoot> entityCategoryList = new LinkedList<JeiEntityLoot>();
    private final List<JeiGameplayLoot> gameplayCategoryList = new LinkedList<JeiGameplayLoot>();
    private final List<JeiTradeLoot> tradeCategoryList = new LinkedList<JeiTradeLoot>();
    private final CompletableFuture<Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>> futureData = new CompletableFuture();

    public void onRuntimeUnavailable() {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.tradeCategoryList.clear();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.PLANT_LOOT, JeiBlockLoot::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, JeiBlockLoot::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.BLOCK_LOOT, JeiBlockLoot::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, JeiEntityLoot::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.ENTITY_LOOT, JeiEntityLoot::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, JeiGameplayLoot::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.GAMEPLAY_LOOT, JeiGameplayLoot::new));
        this.tradeCategoryList.addAll(LootCategories.TRADE_LOOT_CATEGORIES.entrySet().stream().map(e -> JeiCompatibility.createCategory(guiHelper, e, JeiTradeLoot::new)).collect(Collectors.toSet()));
        this.tradeCategoryList.add(JeiCompatibility.createCategory(guiHelper, LootCategories.TRADE_LOOT, JeiTradeLoot::new));
        this.blockCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.entityCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.gameplayCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.tradeCategoryList.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener((lootData, tradeData) -> this.futureData.complete((Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>)Pair.of((Object)lootData, (Object)tradeData)));
        this.futureData.thenAccept(pair -> this.registerData(registration, (Map)pair.getLeft(), (Map)pair.getRight()));
    }

    private void registerData(IRecipeRegistration registration, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.getInstance().level;
        LOGGER.info("Adding loot information to JEI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                RecipeType recipeType = null;
                for (JeiBlockLoot recipeCategory : this.blockCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(block)) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    blockRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new BlockLootType((Block)block, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                RecipeType recipeType = null;
                for (JeiEntityLoot recipeCategory : this.entityCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(entity)) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    entityRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new EntityLootType((Entity)entity, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, outputs) -> {
                RecipeType recipeType = null;
                for (JeiGameplayLoot recipeCategory : this.gameplayCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(location.getPath())) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    gameplayRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new GameplayLootType((IDataNode)node, "/" + location.getPath(), Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(location.getPath())) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategoryList) {
                    if (!recipeCategory.getLootCategory().validate(location.getPath())) continue;
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }

    private static <T, U, V extends IType> T createCategory(IGuiHelper guiHelper, LootCategory<U> e, LootConstructor<T, U, V> constructor) {
        RecipeType recipeType = RecipeType.create((String)"ali", (String)e.getKey(), RecipeHolder.class);
        MutableComponent title = Component.translatable((String)("emi.category.ali." + e.getKey().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e, (Component)title, guiHelper.createDrawableItemStack(e.getIcon()));
    }

    private static <T, U, V extends IType> T createCategory(IGuiHelper guiHelper, Map.Entry<ResourceLocation, LootCategory<U>> e, LootConstructor<T, U, V> constructor) {
        ResourceLocation id = e.getKey();
        RecipeType recipeType = RecipeType.create((String)id.getNamespace(), (String)id.getPath(), RecipeHolder.class);
        MutableComponent title = Component.translatable((String)("emi.category." + id.getNamespace() + "." + id.getPath().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e.getValue(), (Component)title, guiHelper.createDrawableItemStack(e.getValue().getIcon()));
    }

    @FunctionalInterface
    private static interface LootConstructor<T, U, V extends IType> {
        public T construct(IGuiHelper var1, RecipeType<RecipeHolder<V>> var2, LootCategory<U> var3, Component var4, IDrawable var5);
    }
}

