/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.JeiLootSlotWidget;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.registries.LootCategory;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class JeiEntityLoot
extends JeiBaseLoot<EntityLootType, Entity> {
    public JeiEntityLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<EntityLootType>> recipeType, LootCategory<Entity> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EntityLootType> recipe, IFocusGroup iFocusGroup) {
        super.setRecipe(builder, recipe, iFocusGroup);
        SpawnEggItem spawnEgg = SpawnEggItem.byId((EntityType)recipe.type().entity().getType());
        if (spawnEgg != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST).setPosition(1, 1)).setStandardSlotBackground().setSlotName("spawn_egg").addItemLike((ItemLike)spawnEgg);
        }
    }

    @Override
    Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder builder, final EntityLootType recipe) {
        LinkedList<IRecipeWidget> widgets = new LinkedList<IRecipeWidget>();
        LinkedList slotDrawables = new LinkedList();
        builder.getRecipeSlots().findSlotByName("spawn_egg").ifPresent(slotDrawable -> {
            widgets.add((IRecipeWidget)new JeiLootSlotWidget((IRecipeSlotDrawable)slotDrawable, 72, 0, new RangeValue(1.0f)));
            slotDrawables.add(slotDrawable);
        });
        widgets.add(this.createTextWidget(recipe.entity().getDisplayName(), 81, true));
        widgets.add(new IRecipeWidget(){
            private static final int WIDGET_SIZE = 36;
            final Rect rect = new Rect(63, 10, 36, 36);
            final ScreenPosition position = new ScreenPosition(0, 0);

            public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
                GenericUtils.renderEntity(recipe.entity(), this.rect, 162, guiGraphics, (int)mouseX, (int)mouseY);
            }

            @NotNull
            public ScreenPosition getPosition() {
                return this.position;
            }
        });
        return new Pair(widgets, slotDrawables);
    }

    @Override
    int getYOffset(EntityLootType recipe) {
        return 48;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

