/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.server;

import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.ItemFilterImpl;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class LootJsGenericTooltipUtils {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ITooltipNode getItemFilterTooltip(IServerUtils utils, String key, ItemFilter predicate) {
        if (predicate == ItemFilter.NONE) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("NONE")));
        }
        if (predicate == ItemFilter.ANY) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ANY")));
        }
        if (predicate == ItemFilter.EMPTY) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("EMPTY")));
        }
        if (predicate == ItemFilter.ARMOR) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ARMOR")));
        }
        if (predicate == ItemFilter.EDIBLE) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("EDIBLE")));
        }
        if (predicate == ItemFilter.DAMAGEABLE) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("DAMAGEABLE")));
        }
        if (predicate == ItemFilter.DAMAGED) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ENCHANTABLE")));
        }
        if (predicate == ItemFilter.ENCHANTED) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ENCHANTED")));
        }
        if (predicate == ItemFilter.BLOCK_ITEM) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("BLOCK_ITEM")));
        }
        if (predicate instanceof ItemFilterImpl.HasEnchantment) {
            IdFilter type;
            IdFilter levelBounds;
            IdFilter filter;
            ItemFilterImpl.HasEnchantment hasEnchantment = (ItemFilterImpl.HasEnchantment)predicate;
            try {
                IdFilter idFilter;
                filter = idFilter = hasEnchantment.filter();
                levelBounds = idFilter = hasEnchantment.levelBounds();
                type = idFilter = hasEnchantment.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("HAS_ENCHANTMENT")));
            tooltip.add(LootJsGenericTooltipUtils.getIdFilterTooltip(utils, "ali.property.branch.filter", filter));
            tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.levels", (MinMaxBounds.Ints)levelBounds));
            tooltip.add(RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, "ali.property.value.component", type));
            return tooltip;
        }
        if (predicate instanceof ItemFilterImpl.IsEquipmentSlot) {
            EquipmentSlot equipmentSlot;
            Object tooltip;
            ItemFilterImpl.IsEquipmentSlot isEquipmentSlot = (ItemFilterImpl.IsEquipmentSlot)predicate;
            {
                tooltip = isEquipmentSlot.equipmentSlot();
                equipmentSlot = tooltip;
            }
            tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("EQUIPMENT_SLOT")));
            tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.slot", equipmentSlot));
            return tooltip;
        }
        if (predicate instanceof ItemFilterImpl.IsEquipmentSlotGroup) {
            EquipmentSlotGroup equipmentSlotGroup;
            Object tooltip;
            ItemFilterImpl.IsEquipmentSlotGroup isEquipmentSlotGroup = (ItemFilterImpl.IsEquipmentSlotGroup)predicate;
            {
                tooltip = isEquipmentSlotGroup.equipmentSlotGroup();
                equipmentSlotGroup = tooltip;
            }
            tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("EQUIPMENT_SLOT_GROUP")));
            tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.slot_group", equipmentSlotGroup));
            return tooltip;
        }
        if (predicate instanceof ItemFilterImpl.ByItem) {
            boolean checkComponents;
            ItemStack itemStack;
            ItemFilterImpl.ByItem byItem = (ItemFilterImpl.ByItem)predicate;
            {
                ItemStack tooltip;
                itemStack = tooltip = byItem.filter();
                checkComponents = tooltip = byItem.checkComponents();
            }
            TooltipNode tooltip2 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ITEM")));
            tooltip2.add(GenericTooltipUtils.getItemStackTooltip(utils, "ali.property.branch.item", itemStack));
            tooltip2.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.check_components", checkComponents));
            return tooltip2;
        }
        if (predicate instanceof ItemFilterImpl.ByIngredient) {
            Ingredient ingredient;
            ItemFilterImpl.ByIngredient byIngredient = (ItemFilterImpl.ByIngredient)predicate;
            {
                Ingredient tooltip2;
                ingredient = tooltip2 = byIngredient.ingredient();
            }
            TooltipNode tooltip3 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("INGREDIENT")));
            tooltip3.add(utils.getIngredientTooltip(utils, ingredient));
            return tooltip3;
        }
        if (predicate instanceof ItemFilterImpl.ByTag) {
            TagKey tag;
            ItemFilterImpl.ByTag byTag = (ItemFilterImpl.ByTag)predicate;
            {
                TagKey tooltip3;
                tag = tooltip3 = byTag.tag();
            }
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("TAG")));
            tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.null", tag));
            return tooltip;
        }
        if (predicate instanceof ItemFilterImpl.AnyOfToolAction) {
            ItemFilterImpl.AnyOfToolAction toolAction = (ItemFilterImpl.AnyOfToolAction)predicate;
            TooltipNode tooltip4 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ANY_OF_TOOL_ACTION")));
            tooltip4.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.abilities", "ali.property.value.null", toolAction.toolActions(), LootJsGenericTooltipUtils::getItemAbilityTooltip));
            return tooltip4;
        }
        if (predicate instanceof ItemFilterImpl.AllOfToolAction) {
            ItemFilterImpl.AllOfToolAction toolAction = (ItemFilterImpl.AllOfToolAction)predicate;
            TooltipNode tooltip5 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ALL_OF_TOOL_ACTION")));
            tooltip5.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.abilities", "ali.property.value.null", toolAction.toolActions(), LootJsGenericTooltipUtils::getItemAbilityTooltip));
            return tooltip5;
        }
        if (predicate instanceof ItemFilterImpl.Not) {
            ItemFilter itemFilter;
            ItemFilterImpl.Not not = (ItemFilterImpl.Not)predicate;
            {
                ItemFilter tooltip5;
                itemFilter = tooltip5 = not.itemFilter();
            }
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("NOT")));
            tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.branch.filter", itemFilter));
            return tooltip;
        }
        if (predicate instanceof ItemFilterImpl.AllOf) {
            ItemFilterImpl.AllOf allOf = (ItemFilterImpl.AllOf)predicate;
            TooltipNode tooltip6 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ALL_OF")));
            tooltip6.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.filters", "ali.property.value.filter", Arrays.asList(allOf.itemFilters()), LootJsGenericTooltipUtils::getItemFilterTooltip));
            return tooltip6;
        }
        if (predicate instanceof ItemFilterImpl.AnyOf) {
            ItemFilterImpl.AnyOf allOf = (ItemFilterImpl.AnyOf)predicate;
            TooltipNode tooltip7 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("ANY_OF")));
            tooltip7.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.filters", "ali.property.value.filter", Arrays.asList(allOf.itemFilters()), LootJsGenericTooltipUtils::getItemFilterTooltip));
            return tooltip7;
        }
        if (predicate instanceof ItemFilterImpl.Custom) {
            ItemFilterImpl.Custom custom = (ItemFilterImpl.Custom)predicate;
            TooltipNode tooltip8 = new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("CUSTOM")));
            tooltip8.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.description", Optional.ofNullable(custom.description()), GenericTooltipUtils::getStringTooltip));
            return tooltip8;
        }
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value("UNKNOWN")));
    }

    @NotNull
    private static ITooltipNode getIdFilterTooltip(IServerUtils utils, String key, IdFilter filter) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        IdFilter idFilter = filter;
        Objects.requireNonNull(idFilter);
        IdFilter idFilter2 = idFilter;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdFilter.ByLocation.class, IdFilter.ByPattern.class, IdFilter.ByMod.class, IdFilter.Or.class}, (Object)idFilter2, n)) {
            case 0: {
                IdFilter.ByLocation byLocation = (IdFilter.ByLocation)idFilter2;
                tooltip.add(GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.null", byLocation.location()));
                break;
            }
            case 1: {
                IdFilter.ByPattern byPattern = (IdFilter.ByPattern)idFilter2;
                tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.pattern", byPattern.toString()));
                break;
            }
            case 2: {
                IdFilter.ByMod byMod = (IdFilter.ByMod)idFilter2;
                tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.mod", byMod.mod()));
                break;
            }
            case 3: {
                IdFilter.Or or = (IdFilter.Or)idFilter2;
                tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.or", "ali.property.value.null", or.filters(), LootJsGenericTooltipUtils::getIdFilterTooltip));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected IdFilter type: " + String.valueOf(filter));
            }
        }
        return tooltip;
    }

    @NotNull
    private static ITooltipNode getItemAbilityTooltip(IServerUtils utils, String key, ItemAbility itemAbility) {
        return GenericTooltipUtils.getStringTooltip(utils, key, itemAbility.name());
    }
}

