/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.immersive_engineering.trades;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.common.trades.SubTradesNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="blusunrize.immersiveengineering.common.world.Villages$RerollingItemListing")
public class RerollingItemListing
extends BaseAccessor<VillagerTrades.ItemListing>
implements IItemListing {
    private static final Logger LOGGER;
    private static final List<Item> ITEMS;
    private static final Object MAP_INSTANCE;
    private static final Object REVOLVER_INSTANCE;

    public RerollingItemListing(VillagerTrades.ItemListing parent) {
        super(parent);
    }

    @Override
    @NotNull
    public IDataNode getNode(final IServerUtils utils, List<ITooltipNode> conditions) {
        return new SubTradesNode<RerollingItemListing>(utils, this, conditions){

            @Override
            public List<IDataNode> getSubTrades(IServerUtils ignoredUtils, RerollingItemListing ignoredListing) {
                ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                if (RerollingItemListing.this.parent == MAP_INSTANCE) {
                    nodes.add(this.getMapListing());
                } else if (RerollingItemListing.this.parent == REVOLVER_INSTANCE) {
                    for (Item item : ITEMS) {
                        nodes.add(this.getRevolverListing(item));
                    }
                }
                return nodes;
            }

            @NotNull
            private IDataNode getMapListing() {
                ItemStack map = Items.MAP.getDefaultInstance();
                map.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.immersiveengineering.map_orevein"));
                return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(8.0f, 16.0f), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)map), new RangeValue(1.0f), 30, 1, 0.5f, Collections.emptyList());
            }

            @NotNull
            private IDataNode getRevolverListing(Item item) {
                return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(5.0f, 64.0f), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)item.getDefaultInstance()), new RangeValue(1.0f), 30, 1, 0.5f, Collections.emptyList());
            }
        };
    }

    @Override
    public Pair<List<Item>, List<Item>> collectItems(IServerUtils utils) {
        if (this.parent == MAP_INSTANCE) {
            return new Pair(List.of(Items.EMERALD), List.of(Items.MAP));
        }
        if (this.parent == REVOLVER_INSTANCE) {
            return new Pair(List.of(Items.EMERALD), ITEMS);
        }
        return new Pair(List.of(), List.of());
    }

    @NotNull
    private static Item getItem(String name) {
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"immersiveengineering", (String)name));
    }

    static {
        Field typeMapField;
        Class<?> tradesClass;
        LOGGER = LogUtils.getLogger();
        ITEMS = List.of(RerollingItemListing.getItem("gunpart_barrel"), RerollingItemListing.getItem("gunpart_drum"), RerollingItemListing.getItem("gunpart_hammer"));
        Object mapInstance = null;
        Object revolverInstance = null;
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages$OreveinMapForEmeralds");
            typeMapField = tradesClass.getDeclaredField("INSTANCE");
            typeMapField.setAccessible(true);
            mapInstance = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain map instance: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages$RevolverPieceForEmeralds");
            typeMapField = tradesClass.getDeclaredField("INSTANCE");
            typeMapField.setAccessible(true);
            revolverInstance = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain revolver instance: {}", (Object)e.getMessage());
        }
        MAP_INSTANCE = mapInstance;
        REVOLVER_INSTANCE = revolverInstance;
    }
}

