/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DataComponentTooltipUtils {
    public static @Unmodifiable @NotNull ITooltipNode getCustomDataTooltip(IServerUtils utils, CustomData value) {
        return GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.tag", value.copyTag().getAsString());
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntTooltip(IServerUtils utils, int value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getUnbreakableTooltip(IServerUtils utils, Unbreakable value) {
        return GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip());
    }

    public static @Unmodifiable @NotNull ITooltipNode getCustomNameTooltip(IServerUtils utils, Component value) {
        return GenericTooltipUtils.getComponentTooltip(utils, "ali.property.value.custom_name", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getItemNameTooltip(IServerUtils utils, Component value) {
        return GenericTooltipUtils.getComponentTooltip(utils, "ali.property.value.item_name", value);
    }

    @NotNull
    public static ITooltipNode getItemLoreTooltip(IServerUtils utils, ItemLore value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.lines", "ali.property.value.null", value.lines(), GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.styled_lines", "ali.property.value.null", value.styledLines(), GenericTooltipUtils::getComponentTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getRarityTooltip(IServerUtils utils, Rarity value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.rarity", value);
    }

    @NotNull
    public static ITooltipNode getItemEnchantmentsTooltip(IServerUtils utils, ItemEnchantments value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.enchantments", value.enchantments, GenericTooltipUtils::getEnchantmentLevelEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getAdventureModePredicateTooltip(IServerUtils utils, AdventureModePredicate value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.blocks", "ali.property.branch.predicate", value.predicates, GenericTooltipUtils::getBlockPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tooltip", "ali.property.value.null", value.tooltip, GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAttributeModifiersTooltip(IServerUtils utils, ItemAttributeModifiers value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.modifiers", "ali.property.branch.modifier", value.modifiers(), GenericTooltipUtils::getItemAttributeModifiersEntryTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCustomModelDataTooltip(IServerUtils utils, CustomModelData value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value.value());
    }

    public static @Unmodifiable @NotNull ITooltipNode getEmptyTooltip(IServerUtils ignoredUtils, Unit ignoredValue) {
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getBoolTooltip(IServerUtils utils, boolean value) {
        return GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.value", value);
    }

    @NotNull
    public static ITooltipNode getFoodTooltip(IServerUtils utils, FoodProperties food) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.nutrition", food.nutrition()));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.saturation", Float.valueOf(food.saturation())));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.can_always_eat", food.canAlwaysEat()));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.eat_seconds", Float.valueOf(food.eatSeconds())));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.using_converts_to", food.usingConvertsTo(), GenericTooltipUtils::getItemStackTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.effects", "ali.property.branch.effect", food.effects(), GenericTooltipUtils::getPossibleEffectTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getToolTooltip(IServerUtils utils, Tool tool) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.rules", "ali.property.branch.rule", tool.rules(), GenericTooltipUtils::getRuleTooltip));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.default_mining_speed", Float.valueOf(tool.defaultMiningSpeed())));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.damage_per_block", tool.damagePerBlock()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDyedColorTooltip(IServerUtils utils, DyedItemColor value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.rgb", value.rgb()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapColorTooltip(IServerUtils utils, MapItemColor value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.rgb", value.rgb());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapIdTooltip(IServerUtils utils, MapId value) {
        return GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.value", value.id());
    }

    @NotNull
    public static ITooltipNode getMapDecorationsTooltip(IServerUtils utils, MapDecorations value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.decorations", value.decorations(), GenericTooltipUtils::getMapDecorationEntryTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getMapPostProcessingTooltip(IServerUtils utils, MapPostProcessing value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.value", value);
    }

    @NotNull
    public static ITooltipNode getChargedProjectilesTooltip(IServerUtils utils, ChargedProjectiles value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.getItems(), GenericTooltipUtils::getItemStackTooltip);
    }

    @NotNull
    public static ITooltipNode getBundleContentsTooltip(IServerUtils utils, BundleContents value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.items, GenericTooltipUtils::getItemStackTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.fraction", value.weight().toString()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPotionContentsTooltip(IServerUtils utils, PotionContents value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.potion", value.potion(), RegistriesTooltipUtils::getPotionTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.custom_color", value.customColor(), GenericTooltipUtils::getIntegerTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.custom_effects", "ali.property.value.null", value.customEffects(), GenericTooltipUtils::getMobEffectInstanceTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSuspiciousStewEffectsTooltip(IServerUtils utils, SuspiciousStewEffects value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.effects", value.effects(), GenericTooltipUtils::getSuspiciousStewEffectEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getWritableBookContentTooltip(IServerUtils utils, WritableBookContent value) {
        return GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", value.pages(), GenericTooltipUtils::getStringTooltip);
    }

    @NotNull
    public static ITooltipNode getWrittenBookContentTooltip(IServerUtils utils, WrittenBookContent value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.title", value.title(), GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.author", value.author()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.generation", value.generation()));
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", value.pages(), GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.resolved", value.resolved()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getTrimTooltip(IServerUtils utils, ArmorTrim value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(RegistriesTooltipUtils.getTrimMaterialTooltip(utils, "ali.property.value.material", (TrimMaterial)value.material().value()));
        tooltip.add(RegistriesTooltipUtils.getTrimPatternTooltip(utils, "ali.property.value.pattern", (TrimPattern)value.pattern().value()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDebugStickStateTooltip(IServerUtils utils, DebugStickState value) {
        return GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.properties", value.properties(), GenericTooltipUtils::getBlockPropertyEntryTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getInstrumentTooltip(IServerUtils utils, Holder<Instrument> value) {
        return RegistriesTooltipUtils.getInstrumentTooltip(utils, "ali.property.value.value", (Instrument)value.value());
    }

    @NotNull
    public static ITooltipNode getJukeboxPlayableTooltip(IServerUtils utils, JukeboxPlayable value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getEitherHolderTooltip(utils, "ali.property.value.song", value.song(), RegistriesTooltipUtils::getJukeboxSongTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.show_in_tooltip", value.showInTooltip()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipesTooltip(IServerUtils utils, List<ResourceLocation> value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.recipes", "ali.property.value.null", value, GenericTooltipUtils::getResourceLocationTooltip);
    }

    @NotNull
    public static ITooltipNode getLodestoneTrackerTooltip(IServerUtils utils, LodestoneTracker value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.global_pos", value.target(), GenericTooltipUtils::getGlobalPosTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.tracked", value.tracked()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFireworkExplosionTooltip(IServerUtils utils, FireworkExplosion value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.shape", value.shape()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.colors", value.colors().toString()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.fade_colors", value.fadeColors().toString()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_trail", value.hasTrail()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.has_twinkle", value.hasTwinkle()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFireworksTooltip(IServerUtils utils, Fireworks value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.flight_duration", value.flightDuration()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.explosions", "ali.property.branch.explosion", value.explosions(), GenericTooltipUtils::getFireworkExplosionTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getProfileTooltip(IServerUtils utils, ResolvableProfile value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.name", value.name(), GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.uuid", value.id(), GenericTooltipUtils::getUUIDTooltip));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.properties", value.properties().asMap(), GenericTooltipUtils::getPropertiesEntryTooltip));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getNoteBlockSoundTooltip(IServerUtils utils, ResourceLocation value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.value", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getBannerPatternsTooltip(IServerUtils utils, BannerPatternLayers value) {
        return GenericTooltipUtils.getBannerPatternLayersTooltip(utils, "ali.property.branch.banner_patterns", value);
    }

    public static @Unmodifiable @NotNull ITooltipNode getBaseColorTooltip(IServerUtils utils, DyeColor value) {
        return GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", value);
    }

    @NotNull
    public static ITooltipNode getPotDecorationsTooltip(IServerUtils utils, PotDecorations value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.back", value.back(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.left", value.left(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.right", value.right(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.front", value.front(), RegistriesTooltipUtils::getItemTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getContainerTooltip(IServerUtils utils, ItemContainerContents value) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.items", "ali.property.branch.item", value.items, GenericTooltipUtils::getItemStackTooltip);
    }

    @NotNull
    public static ITooltipNode getBlockStateTooltip(IServerUtils ignoredUtils, BlockItemStateProperties properties) {
        return GenericTooltipUtils.getMapTooltip(ignoredUtils, "ali.property.branch.properties", properties.properties(), GenericTooltipUtils::getStringEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getBeesTooltip(IServerUtils utils, List<BeehiveBlockEntity.Occupant> properties) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.bees", "ali.property.branch.occupant", properties, GenericTooltipUtils::getBeehiveBlockEntityOccupantTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getLockTooltip(IServerUtils utils, LockCode lockCode) {
        return GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.value", lockCode.key());
    }

    public static @Unmodifiable @NotNull ITooltipNode getContainerLootTooltip(IServerUtils utils, SeededContainerLoot value) {
        TooltipNode tooltip = new TooltipNode();
        tooltip.add(GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.property.value.loot_table", value.lootTable()));
        tooltip.add(GenericTooltipUtils.getLongTooltip(utils, "ali.property.value.seed", value.seed()));
        return tooltip;
    }
}

