/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.client.ModifierSourceType;
import dev.shadowsoffire.apothic_attributes.util.Comparators;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public abstract class ModifierSource<T>
implements Comparable<ModifierSource<T>> {
    protected final ModifierSourceType<T> type;
    protected final Comparator<T> comparator;
    protected final T data;

    public ModifierSource(ModifierSourceType<T> type, Comparator<T> comparator, T data) {
        this.type = type;
        this.comparator = comparator;
        this.data = data;
    }

    public abstract void render(GuiGraphics var1, Font var2, int var3, int var4);

    public ModifierSourceType<T> getType() {
        return this.type;
    }

    public final T getData() {
        return this.data;
    }

    @Override
    public int compareTo(ModifierSource<T> o) {
        return this.comparator.compare(this.getData(), o.getData());
    }

    public static class EffectModifierSource
    extends ModifierSource<MobEffectInstance> {
        public EffectModifierSource(MobEffectInstance data) {
            super(ModifierSourceType.MOB_EFFECT, Comparator.comparing(inst -> (ResourceKey)inst.getEffect().unwrapKey().get(), ResourceKey::compareTo), data);
        }

        @Override
        public void render(GuiGraphics gfx, Font font, int x, int y) {
            MobEffectTextureManager texMgr = Minecraft.getInstance().getMobEffectTextures();
            Holder effect = ((MobEffectInstance)this.data).getEffect();
            TextureAtlasSprite sprite = texMgr.get(effect);
            float scale = 0.5f;
            PoseStack stack = gfx.pose();
            stack.pushPose();
            stack.scale(scale, scale, 1.0f);
            stack.translate((float)x / scale, (float)y / scale, 0.0f);
            gfx.blit(0, 0, 0, 18, 18, sprite);
            stack.popPose();
        }
    }

    public static class ItemModifierSource
    extends ModifierSource<ItemStack> {
        public ItemModifierSource(ItemStack data) {
            super(ModifierSourceType.EQUIPMENT, Comparator.comparing(arg_0 -> ((LocalPlayer)Minecraft.getInstance().player).getEquipmentSlotForItem(arg_0)).reversed().thenComparing(Comparator.comparing(ItemStack::getItem, Comparators.idComparator(BuiltInRegistries.ITEM))), data);
        }

        @Override
        public void render(GuiGraphics gfx, Font font, int x, int y) {
            PoseStack pose = gfx.pose();
            pose.pushPose();
            float scale = 0.5f;
            pose.scale(scale, scale, 1.0f);
            pose.translate(1.0f + (float)x / scale, 1.0f + (float)y / scale, 0.0f);
            gfx.renderFakeItem((ItemStack)this.data, 0, 0);
            pose.popPose();
        }
    }
}

