/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.capability;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;

public class TridentSlotCapability
extends CapabilityComponent<ThrownTrident> {
    private static final String TAG_TRIDENT_SLOT = "trident_slot";
    private int slot = -1;

    public void setSlot(int slot) {
        if (this.slot != slot) {
            this.slot = slot;
            this.setChanged();
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean addItemToInventory(Player player, ItemStack itemStack) {
        this.verifyEquippedItem(itemStack);
        Inventory inventory = player.getInventory();
        int slot = this.findSlotAtIndex(inventory, this.getSlot());
        if (slot != -1) {
            inventory.setItem(slot, itemStack.copy());
            inventory.getItem(slot).setPopTime(5);
            itemStack.setCount(0);
            return true;
        }
        return inventory.add(itemStack);
    }

    private void verifyEquippedItem(ItemStack itemStack) {
        itemStack.getItem().verifyComponentsAfterLoad(itemStack);
    }

    private int findSlotAtIndex(Inventory inventory, int slot) {
        if (slot != -1 && inventory.getItem(slot).isEmpty()) {
            return slot;
        }
        if (inventory.getSelected().isEmpty()) {
            return inventory.selected;
        }
        return -1;
    }

    public void write(CompoundTag compoundTag, HolderLookup.Provider registries) {
        if (this.slot != -1) {
            compoundTag.putInt(TAG_TRIDENT_SLOT, this.slot);
        }
    }

    public void read(CompoundTag compoundTag, HolderLookup.Provider registries) {
        this.slot = compoundTag.getInt(TAG_TRIDENT_SLOT);
    }
}

