/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.item;

import biomesoplenty.entity.BoatBOP;
import biomesoplenty.entity.ChestBoatBOP;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class BoatDispenseItemBehaviourBOP
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final BoatBOP.ModelType type;
    private final boolean hasChest;

    public BoatDispenseItemBehaviourBOP(boolean hasChest, BoatBOP.ModelType type) {
        this.type = type;
        this.hasChest = hasChest;
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        Object boat;
        double d3;
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        ServerLevel level = source.level();
        double d0 = (double)source.pos().getX() + (double)((float)direction.getStepX() * 1.125f);
        double d1 = (double)source.pos().getY() + (double)((float)direction.getStepY() * 1.125f);
        double d2 = (double)source.pos().getZ() + (double)((float)direction.getStepZ() * 1.125f);
        BlockPos blockpos = source.pos().relative(direction);
        if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
            d3 = 1.0;
        } else {
            if (!level.getBlockState(blockpos).isAir() || !level.getFluidState(blockpos.below()).is(FluidTags.WATER)) {
                return this.defaultDispenseItemBehavior.dispense(source, stack);
            }
            d3 = 0.0;
        }
        if (this.hasChest) {
            boat = new ChestBoatBOP((Level)level, d0, d1 + d3, d2);
            ((ChestBoatBOP)((Object)boat)).setModel(this.type);
        } else {
            boat = new BoatBOP((Level)level, d0, d1 + d3, d2);
            ((BoatBOP)((Object)boat)).setModel(this.type);
        }
        boat.setYRot(direction.toYRot());
        level.addFreshEntity((Entity)boat);
        stack.shrink(1);
        return stack;
    }

    protected void playSound(BlockSource p_123373_) {
        p_123373_.level().levelEvent(1000, p_123373_.pos(), 0);
    }
}

