/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="carryonextend", value={Dist.CLIENT})
public class ClientThrowHandler {
    private static final int THROW_EFFECT_DURATION = 10;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player.getPersistentData().contains("ThrowTime")) {
            long throwTime = player.getPersistentData().getLong("ThrowTime");
            long currentTime = player.level().getGameTime();
            long elapsedTicks = currentTime - throwTime;
            if (elapsedTicks < 10L) {
                double vx = player.getPersistentData().getDouble("ThrowVelocityX");
                double vy = player.getPersistentData().getDouble("ThrowVelocityY");
                double vz = player.getPersistentData().getDouble("ThrowVelocityZ");
                Vec3 currentMotion = player.getDeltaMovement();
                float factor = 1.0f - (float)elapsedTicks / 10.0f;
                double additionalY = currentMotion.y < 0.0 ? 0.08 * (double)factor : 0.0;
                double newVx = currentMotion.x * 0.6 + vx * 0.4 * (double)factor;
                double newVy = Math.max(currentMotion.y, vy * (double)factor) + additionalY;
                double newVz = currentMotion.z * 0.6 + vz * 0.4 * (double)factor;
                player.setDeltaMovement(newVx, newVy, newVz);
                player.hurtMarked = true;
                player.setOnGround(false);
                player.fallDistance = 0.0f;
            } else {
                player.getPersistentData().remove("ThrowTime");
                player.getPersistentData().remove("ThrowVelocityX");
                player.getPersistentData().remove("ThrowVelocityY");
                player.getPersistentData().remove("ThrowVelocityZ");
            }
        }
    }
}

