/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

@EventBusSubscriber(modid="carryonextend", value={Dist.CLIENT})
public class PowerThrowHandler {
    private static final int MAX_POWER_STEPS = 10;
    private static int powerLevel = 10;

    public static float getPowerFactor() {
        float minPower = 0.1f;
        if (powerLevel == 1) {
            return minPower;
        }
        return minPower + (float)(powerLevel - 1) / 9.0f * (1.0f - minPower);
    }

    public static void increasePower() {
        if (powerLevel < 10) {
            ++powerLevel;
            PowerThrowHandler.playPowerChangeSound();
            PowerThrowHandler.displayPowerLevel();
        }
    }

    public static void decreasePower() {
        if (powerLevel > 1) {
            --powerLevel;
            PowerThrowHandler.playPowerChangeSound();
            PowerThrowHandler.displayPowerLevel();
        }
    }

    public static void displayPowerLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        float percentage = PowerThrowHandler.getPowerFactor() * 100.0f;
        MutableComponent message = Component.translatable((String)"message.carryonextend.power_level", (Object[])new Object[]{powerLevel, 10, (int)percentage});
        player.displayClientMessage((Component)message, true);
    }

    private static void playPowerChangeSound() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        float pitch = 0.5f + PowerThrowHandler.getPowerFactor() * 1.0f;
        player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.2f, pitch, false);
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        CarryOnData carry;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown() && ((carry = CarryOnDataManager.getCarryData((Player)player)).isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryOnData.CarryType.PLAYER) || carry.isCarrying(CarryOnData.CarryType.BLOCK))) {
            if (event.getScrollDeltaY() > 0.0) {
                PowerThrowHandler.increasePower();
            } else if (event.getScrollDeltaY() < 0.0) {
                PowerThrowHandler.decreasePower();
            }
            event.setCanceled(true);
        }
    }
}

