/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.prizowo.carryonextend.registry.CustomFallingBlockEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CustomFallingBlockRenderer
extends EntityRenderer<CustomFallingBlockEntity> {
    private final BlockRenderDispatcher dispatcher;
    private float partialTicks;

    public CustomFallingBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(CustomFallingBlockEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        this.partialTicks = partialTicks;
        BlockState blockState = entity.getBlockState();
        if (blockState.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        Level level = entity.level();
        BlockPos renderPos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        poseStack.pushPose();
        try {
            poseStack.translate(-0.5, 0.0, -0.5);
            if (blockState.hasBlockEntity()) {
                this.renderBlockWithEntity(entity, blockState, level, renderPos, poseStack, buffer, packedLight);
            } else {
                this.renderBlockModel(blockState, level, renderPos, poseStack, buffer, packedLight, false);
            }
        }
        finally {
            poseStack.popPose();
        }
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockWithEntity(CustomFallingBlockEntity entity, BlockState blockState, Level level, BlockPos renderPos, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        BlockEntityRenderer<BlockEntity> renderer;
        BlockEntityType<?> blockEntityType = this.findBlockEntityType(blockState);
        if (blockEntityType == null) {
            this.renderBlockModel(blockState, level, renderPos, poseStack, buffer, packedLight, true);
            return;
        }
        BlockEntity blockEntity = this.createBlockEntityInstance(blockState, blockEntityType, renderPos);
        if (blockEntity == null) {
            this.renderBlockModel(blockState, level, renderPos, poseStack, buffer, packedLight, true);
            return;
        }
        blockEntity.setLevel(level);
        if (entity.getBlockData() != null && !entity.getBlockData().isEmpty()) {
            try {
                blockEntity.loadWithComponents(entity.getBlockData(), (HolderLookup.Provider)level.registryAccess());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            this.renderBlockModel(blockState, level, renderPos, poseStack, buffer, packedLight, true);
        }
        if ((renderer = this.getBlockEntityRenderer(blockEntity)) != null) {
            poseStack.pushPose();
            try {
                poseStack.translate(0.5, 0.5, 0.5);
                renderer.render(blockEntity, this.partialTicks, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                poseStack.popPose();
            }
        }
    }

    private BlockEntityType<?> findBlockEntityType(BlockState blockState) {
        for (BlockEntityType type : BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            try {
                if (!type.isValid(blockState)) continue;
                return type;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private BlockEntity createBlockEntityInstance(BlockState blockState, BlockEntityType<?> blockEntityType, BlockPos pos) {
        try {
            return blockEntityType.create(pos, blockState);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void renderBlockModel(BlockState blockState, Level level, BlockPos renderPos, PoseStack poseStack, MultiBufferSource buffer, int packedLight, boolean useTranslucentMovingBlock) {
        BakedModel model = this.dispatcher.getBlockModel(blockState);
        RandomSource randomSource = RandomSource.create();
        ModelData modelData = ModelData.EMPTY;
        BlockEntity be = level.getBlockEntity(renderPos);
        if (be != null) {
            modelData = be.getModelData();
        }
        for (RenderType renderType : model.getRenderTypes(blockState, randomSource, modelData)) {
            RenderType actualRenderType = useTranslucentMovingBlock ? RenderType.translucentMovingBlock() : renderType;
            this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockState, renderPos, poseStack, buffer.getBuffer(actualRenderType), false, randomSource, blockState.getSeed(renderPos), OverlayTexture.NO_OVERLAY, modelData, actualRenderType);
        }
    }

    private <T extends BlockEntity> BlockEntityRenderer<T> getBlockEntityRenderer(T blockEntity) {
        try {
            return Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CustomFallingBlockEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

