/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.carryonextend.handler;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.prizowo.carryonextend.util.FallingBlockEntityUtil;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class BlockThrowHandler {
    private static final float BASE_THROW_POWER = 0.8f;
    private static final float BASE_THROW_UPWARD = 0.3f;
    private static final float MAX_POWER_MULTIPLIER = 2.5f;

    public static void throwCarriedBlock(ServerPlayer player) {
        BlockThrowHandler.throwCarriedBlockWithPower(player, 1.0f);
    }

    public static void throwCarriedBlockWithPower(ServerPlayer player, float powerFactor) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            return;
        }
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState blockState = carry.getBlock();
        Vec3 playerPos = player.getEyePosition().add(player.getLookAngle().scale(0.5));
        BlockPos tempPos = new BlockPos((int)playerPos.x, (int)playerPos.y, (int)playerPos.z);
        BlockEntity blockEntity = carry.getBlockEntity(tempPos, (HolderLookup.Provider)level.registryAccess());
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = ((CarryOnScript)carry.getActiveScript().get()).scriptEffects()).commandPlace()).isEmpty()) {
            player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd);
        }
        float powerMult = 1.0f + powerFactor * 1.5f;
        Vec3 lookDir = player.getLookAngle();
        Vec3 motion = new Vec3(lookDir.x * (double)0.8f * (double)powerMult, (double)(0.3f * powerMult), lookDir.z * (double)0.8f * (double)powerMult);
        CompoundTag blockData = blockEntity != null ? blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()) : new CompoundTag();
        FallingBlockEntityUtil.throwBlock(level, playerPos.x, playerPos.y, playerPos.z, blockState, blockData, motion);
        float pitch = Math.max(0.5f, Math.min(1.8f, 0.8f + powerFactor * 0.8f));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 0.8f, pitch);
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, (CarryOnData)carry);
        player.swing(InteractionHand.MAIN_HAND, true);
    }
}

